/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent.maintenance;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.yahoo.concurrent.maintenance.JobControl;
import com.yahoo.net.HostName;
import com.yahoo.transaction.Mutex;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Maintainer
implements Runnable,
AutoCloseable {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final String name;
    private final JobControl jobControl;
    private final Duration interval;
    private final ScheduledExecutorService service;

    public Maintainer(String name, Duration interval, Instant startedAt, JobControl jobControl, List<String> clusterHostnames) {
        this(name, interval, Maintainer.staggeredDelay(interval, startedAt, HostName.getLocalhost(), clusterHostnames), jobControl);
    }

    public Maintainer(String name, Duration interval, Duration initialDelay, JobControl jobControl) {
        this.name = name;
        this.interval = Maintainer.requireInterval(interval);
        this.jobControl = Objects.requireNonNull(jobControl);
        this.service = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, this.name() + "-worker"));
        this.service.scheduleAtFixedRate(this, initialDelay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        jobControl.started(this.name(), this);
    }

    @Override
    public void run() {
        try {
            if (this.jobControl.isActive(this.name())) {
                this.lockAndMaintain();
            }
        }
        catch (UncheckedTimeoutException uncheckedTimeoutException) {
        }
        catch (Throwable e) {
            this.log.log(Level.WARNING, this + " failed. Will retry in " + this.interval.toMinutes() + " minutes", e);
        }
    }

    @Override
    public void close() {
        Duration timeout = Duration.ofSeconds(30L);
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                this.log.log(Level.WARNING, "Maintainer " + this.name() + " failed to shutdown within " + timeout);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public final String toString() {
        return this.name();
    }

    protected abstract void maintain();

    protected Duration interval() {
        return this.interval;
    }

    public final void lockAndMaintain() {
        try (Mutex lock = this.jobControl.lockJob(this.name());){
            this.maintain();
        }
    }

    public final String name() {
        return this.name == null ? this.getClass().getSimpleName() : this.name;
    }

    static Duration staggeredDelay(Duration interval, Instant now, String hostname, List<String> clusterHostnames) {
        Objects.requireNonNull(clusterHostnames);
        if (!clusterHostnames.contains(hostname)) {
            return interval;
        }
        long offset = (long)clusterHostnames.indexOf(hostname) * interval.toMillis() / (long)clusterHostnames.size();
        return Duration.ofMillis(Math.floorMod(offset - now.toEpochMilli(), interval.toMillis()));
    }

    private static Duration requireInterval(Duration interval) {
        Objects.requireNonNull(interval);
        if (interval.isNegative() || interval.isZero()) {
            throw new IllegalArgumentException("Interval must be positive, but was " + interval);
        }
        return interval;
    }
}

