/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent.maintenance;

import com.yahoo.concurrent.maintenance.Maintainer;
import com.yahoo.transaction.Mutex;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

public class JobControl {
    private final Map<String, Maintainer> startedJobs = new ConcurrentSkipListMap<String, Maintainer>();
    private final Db db;

    public JobControl(Db db) {
        this.db = db;
    }

    public void started(String jobSimpleClassName, Maintainer maintainer) {
        this.startedJobs.put(jobSimpleClassName, maintainer);
    }

    public Set<String> jobs() {
        return Collections.unmodifiableSet(this.startedJobs.keySet());
    }

    public Set<String> inactiveJobs() {
        return this.db.readInactiveJobs();
    }

    public boolean isActive(String jobSimpleClassName) {
        return !this.inactiveJobs().contains(jobSimpleClassName);
    }

    public void setActive(String jobSimpleClassName, boolean active) {
        try (Mutex lock = this.db.lockInactiveJobs();){
            Set<String> inactiveJobs = this.db.readInactiveJobs();
            if (active) {
                inactiveJobs.remove(jobSimpleClassName);
            } else {
                inactiveJobs.add(jobSimpleClassName);
            }
            this.db.writeInactiveJobs(inactiveJobs);
        }
    }

    public void run(String jobSimpleClassName) {
        Maintainer job = this.startedJobs.get(jobSimpleClassName);
        if (job == null) {
            throw new IllegalArgumentException("No such job '" + jobSimpleClassName + "'");
        }
        job.lockAndMaintain();
    }

    public Mutex lockJob(String jobSimpleClassName) {
        return this.db.lockMaintenanceJob(jobSimpleClassName);
    }

    public static interface Db {
        public Set<String> readInactiveJobs();

        public void writeInactiveJobs(Set<String> var1);

        public Mutex lockInactiveJobs();

        public Mutex lockMaintenanceJob(String var1);
    }
}

