/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.annotations.Beta;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.ScalarFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Beta
public class Value<NAMETYPE extends Name>
extends PrimitiveTensorFunction<NAMETYPE> {
    private final TensorFunction<NAMETYPE> argument;
    private final List<DimensionValue<NAMETYPE>> cellAddress;

    public Value(TensorFunction<NAMETYPE> argument, List<DimensionValue<NAMETYPE>> cellAddress) {
        this.argument = Objects.requireNonNull(argument, "Argument cannot be null");
        if (cellAddress.size() > 1 && cellAddress.stream().anyMatch(c -> c.dimension().isEmpty())) {
            throw new IllegalArgumentException("Short form of cell addresses is only supported with a single dimension: Specify dimension names explicitly");
        }
        this.cellAddress = cellAddress;
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return List.of(this.argument);
    }

    @Override
    public Value<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Value takes exactly one argument but got " + arguments.size());
        }
        return new Value<NAMETYPE>(arguments.get(0), this.cellAddress);
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return this;
    }

    @Override
    public Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        Tensor tensor = this.argument.evaluate(context);
        if (tensor.type().rank() != this.cellAddress.size()) {
            throw new IllegalArgumentException("Type/address size mismatch: Cannot address a value with " + this.toString() + " to a tensor of type " + tensor.type());
        }
        TensorAddress.Builder b = new TensorAddress.Builder(tensor.type());
        for (int i = 0; i < this.cellAddress.size(); ++i) {
            if (this.cellAddress.get(i).label().isPresent()) {
                b.add(this.cellAddress.get(i).dimension().orElse(tensor.type().dimensions().get(i).name()), this.cellAddress.get(i).label().get());
                continue;
            }
            b.add(this.cellAddress.get(i).dimension().orElse(tensor.type().dimensions().get(i).name()), String.valueOf(this.cellAddress.get(i).index().get().apply(context).intValue()));
        }
        return Tensor.from(tensor.get(b.build()));
    }

    @Override
    public TensorType type(TypeContext<NAMETYPE> context) {
        return new TensorType.Builder(this.argument.type(context).valueType()).build();
    }

    @Override
    public String toString(ToStringContext context) {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.cellAddress.size() == 1 && this.cellAddress.get(0).dimension().isEmpty()) {
            if (this.cellAddress.get(0).index().isPresent()) {
                return "[" + this.cellAddress.get(0).index().get() + "]";
            }
            return "{" + this.cellAddress.get(0).label() + "}";
        }
        return "{" + this.cellAddress.stream().map(i -> i.toString()).collect(Collectors.joining(", ")) + "}";
    }

    private static class ConstantScalarFunction<NAMETYPE extends Name>
    implements ScalarFunction<NAMETYPE> {
        private final Double value;

        public ConstantScalarFunction(int value) {
            this.value = value;
        }

        @Override
        public Double apply(EvaluationContext<NAMETYPE> context) {
            return this.value;
        }
    }

    public static class DimensionValue<NAMETYPE extends Name> {
        private final Optional<String> dimension;
        private final String label;
        private final ScalarFunction<NAMETYPE> index;

        public DimensionValue(String dimension, String label) {
            this(Optional.of(dimension), label, null);
        }

        public DimensionValue(String dimension, int index) {
            this(Optional.of(dimension), null, new ConstantScalarFunction(index));
        }

        public DimensionValue(int index) {
            this(Optional.empty(), null, new ConstantScalarFunction(index));
        }

        public DimensionValue(String label) {
            this(Optional.empty(), label, null);
        }

        public DimensionValue(ScalarFunction<NAMETYPE> index) {
            this(Optional.empty(), null, index);
        }

        public DimensionValue(Optional<String> dimension, String label) {
            this(dimension, label, null);
        }

        public DimensionValue(Optional<String> dimension, ScalarFunction<NAMETYPE> index) {
            this(dimension, null, index);
        }

        public DimensionValue(String dimension, ScalarFunction<NAMETYPE> index) {
            this(Optional.of(dimension), null, index);
        }

        private DimensionValue(Optional<String> dimension, String label, ScalarFunction<NAMETYPE> index) {
            this.dimension = dimension;
            this.label = label;
            this.index = index;
        }

        public Optional<String> dimension() {
            return this.dimension;
        }

        public Optional<String> label() {
            return Optional.ofNullable(this.label);
        }

        public Optional<ScalarFunction<NAMETYPE>> index() {
            return Optional.ofNullable(this.index);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            this.dimension.ifPresent(d -> b.append((String)d).append(":"));
            if (this.label != null) {
                b.append(this.label);
            } else {
                b.append(this.index);
            }
            return b.toString();
        }
    }
}

