/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Range
extends CompositeTensorFunction {
    private final TensorType type;
    private final Function<List<Long>, Double> rangeFunction;

    public Range(TensorType type) {
        this.type = type;
        this.rangeFunction = ScalarFunctions.sum(this.dimensionNames().collect(Collectors.toList()));
    }

    @Override
    public List<TensorFunction> arguments() {
        return Collections.emptyList();
    }

    @Override
    public TensorFunction withArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 0) {
            throw new IllegalArgumentException("Range must have 0 arguments, got " + arguments.size());
        }
        return this;
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        return new Generate(this.type, this.rangeFunction);
    }

    @Override
    public String toString(ToStringContext context) {
        return "range(" + this.dimensionNames().collect(Collectors.joining(",")) + ")" + this.rangeFunction;
    }

    private Stream<String> dimensionNames() {
        return this.type.dimensions().stream().map(TensorType.Dimension::toString);
    }
}

