/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class Generate
extends PrimitiveTensorFunction {
    private final TensorType type;
    private final Function<List<Long>, Double> generator;

    public Generate(TensorType type, Function<List<Long>, Double> generator) {
        Objects.requireNonNull(type, "The argument tensor type cannot be null");
        Objects.requireNonNull(generator, "The argument function cannot be null");
        this.validateType(type);
        this.type = type;
        this.generator = generator;
    }

    private void validateType(TensorType type) {
        for (TensorType.Dimension dimension : type.dimensions()) {
            if (dimension.type() == TensorType.Dimension.Type.indexedBound) continue;
            throw new IllegalArgumentException("A generated tensor can only have indexed bound dimensions");
        }
    }

    @Override
    public List<TensorFunction> arguments() {
        return Collections.emptyList();
    }

    @Override
    public TensorFunction withArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 0) {
            throw new IllegalArgumentException("Generate must have 0 arguments, got " + arguments.size());
        }
        return this;
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        return this;
    }

    @Override
    public <NAMETYPE extends TypeContext.Name> TensorType type(TypeContext<NAMETYPE> context) {
        return this.type;
    }

    @Override
    public <NAMETYPE extends TypeContext.Name> Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        Tensor.Builder builder = Tensor.Builder.of(this.type);
        IndexedTensor.Indexes indexes = IndexedTensor.Indexes.of(this.dimensionSizes(this.type));
        int i = 0;
        while ((long)i < indexes.size()) {
            indexes.next();
            builder.cell(this.generator.apply(indexes.toList()), indexes.indexesForReading());
            ++i;
        }
        return builder.build();
    }

    private DimensionSizes dimensionSizes(TensorType type) {
        DimensionSizes.Builder b = new DimensionSizes.Builder(type.dimensions().size());
        for (int i = 0; i < b.dimensions(); ++i) {
            b.set(i, type.dimensions().get(i).size().get());
        }
        return b.build();
    }

    @Override
    public String toString(ToStringContext context) {
        return this.type + "(" + this.generator + ")";
    }
}

