/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.TensorType;
import java.util.Arrays;

public final class DimensionSizes {
    private final long[] sizes;

    private DimensionSizes(Builder builder) {
        this.sizes = builder.sizes;
        builder.sizes = null;
    }

    public static DimensionSizes of(TensorType type) {
        Builder b = new Builder(type.rank());
        for (int i = 0; i < type.rank(); ++i) {
            if (type.dimensions().get(i).type() != TensorType.Dimension.Type.indexedBound) {
                throw new IllegalArgumentException(type + " contains dimensions without a size");
            }
            b.set(i, type.dimensions().get(i).size().get());
        }
        return b.build();
    }

    public long size(int dimensionIndex) {
        if (dimensionIndex < 0 || dimensionIndex >= this.sizes.length) {
            throw new IllegalArgumentException("Illegal dimension index " + dimensionIndex + ": This has " + this.sizes.length + " dimensions");
        }
        return this.sizes[dimensionIndex];
    }

    public int dimensions() {
        return this.sizes.length;
    }

    public long totalSize() {
        long productSize = 1L;
        for (long dimensionSize : this.sizes) {
            productSize *= dimensionSize;
        }
        return productSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionSizes)) {
            return false;
        }
        return Arrays.equals(((DimensionSizes)o).sizes, this.sizes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sizes);
    }

    public static final class Builder {
        private long[] sizes;

        public Builder(int dimensions) {
            this.sizes = new long[dimensions];
        }

        public Builder set(int dimensionIndex, long size) {
            this.sizes[dimensionIndex] = size;
            return this;
        }

        public long size(int dimensionIndex) {
            if (dimensionIndex < 0 || dimensionIndex >= this.sizes.length) {
                throw new IllegalArgumentException("Illegal dimension index " + dimensionIndex + ": This has " + this.sizes.length + " dimensions");
            }
            return this.sizes[dimensionIndex];
        }

        public int dimensions() {
            return this.sizes.length;
        }

        public DimensionSizes build() {
            return new DimensionSizes(this);
        }
    }
}

