/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractFilteringList<Type, ListType extends AbstractFilteringList<Type, ListType>> {
    private final List<Type> items;
    private final boolean negate;
    private final BiFunction<List<Type>, Boolean, ListType> constructor;

    protected AbstractFilteringList(Collection<? extends Type> items, boolean negate, BiFunction<List<Type>, Boolean, ListType> constructor) {
        this.items = List.copyOf(items);
        this.negate = negate;
        this.constructor = constructor;
    }

    public final ListType not() {
        return (ListType)((AbstractFilteringList)this.constructor.apply(this.items, !this.negate));
    }

    public final ListType matching(Predicate<Type> condition) {
        return (ListType)((AbstractFilteringList)this.constructor.apply(this.items.stream().filter(this.negate ? condition.negate() : condition).collect(Collectors.toUnmodifiableList()), false));
    }

    public ListType first(int n) {
        n = Math.min(n, this.items.size());
        return (ListType)((AbstractFilteringList)this.constructor.apply(this.items.subList(this.negate ? n : 0, this.negate ? this.items.size() : n), false));
    }

    public Optional<Type> first() {
        return this.items.stream().findFirst();
    }

    public ListType in(ListType others) {
        return this.matching(new HashSet<Type>(((AbstractFilteringList)others).asList())::contains);
    }

    public ListType and(ListType others) {
        return (ListType)((AbstractFilteringList)this.constructor.apply(Stream.concat(this.items.stream(), ((AbstractFilteringList)others).asList().stream()).collect(Collectors.toUnmodifiableList()), false));
    }

    public final List<Type> asList() {
        return this.items;
    }

    public final <OtherType> List<OtherType> mapToList(Function<Type, OtherType> mapper) {
        return this.items.stream().map(mapper).collect(Collectors.toUnmodifiableList());
    }

    public final ListType sortedBy(Comparator<? super Type> comparator) {
        return (ListType)((AbstractFilteringList)this.constructor.apply(this.items.stream().sorted(comparator).collect(Collectors.toUnmodifiableList()), false));
    }

    public final boolean isEmpty() {
        return this.items.isEmpty();
    }

    public final int size() {
        return this.items.size();
    }
}

