/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class Ascii {
    public static final char ESCAPE_CHAR = '\\';

    public static String encode(String str, Charset charset, int ... requiresEscape) {
        return Ascii.newEncoder(charset, requiresEscape).encode(str);
    }

    public static String decode(String str, Charset charset) {
        return Ascii.newDecoder(charset).decode(str);
    }

    public static Encoder newEncoder(Charset charset, int ... requiresEscape) {
        switch (requiresEscape.length) {
            case 0: {
                return new Encoder(charset, new EmptyPredicate());
            }
            case 1: {
                return new Encoder(charset, new SingletonPredicate(requiresEscape[0]));
            }
        }
        return new Encoder(charset, new ArrayPredicate(requiresEscape));
    }

    public static Decoder newDecoder(Charset charset) {
        return new Decoder(charset);
    }

    private static class CodePointIterator
    implements Iterator<Integer> {
        final String str;
        int idx = 0;

        CodePointIterator(String str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.str.length();
        }

        @Override
        public Integer next() {
            int c = this.str.codePointAt(this.idx);
            this.idx += Character.charCount(c);
            return c;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CodePointSequence
    implements Iterable<Integer> {
        final String str;

        CodePointSequence(String str) {
            this.str = str;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new CodePointIterator(this.str);
        }
    }

    private static class ArrayPredicate
    implements EncodePredicate {
        final Set<Integer> requiresEscape = new TreeSet<Integer>();

        private ArrayPredicate(int[] requiresEscape) {
            for (int codePoint : requiresEscape) {
                this.requiresEscape.add(codePoint);
            }
        }

        @Override
        public boolean requiresEscape(int codePoint) {
            return this.requiresEscape.contains(codePoint);
        }
    }

    private static class SingletonPredicate
    implements EncodePredicate {
        final int requiresEscape;

        private SingletonPredicate(int requiresEscape) {
            this.requiresEscape = requiresEscape;
        }

        @Override
        public boolean requiresEscape(int codePoint) {
            return codePoint == this.requiresEscape;
        }
    }

    private static class EmptyPredicate
    implements EncodePredicate {
        private EmptyPredicate() {
        }

        @Override
        public boolean requiresEscape(int codePoint) {
            return false;
        }
    }

    private static interface EncodePredicate {
        public boolean requiresEscape(int var1);
    }

    public static class Decoder {
        private final Charset charset;

        private Decoder(Charset charset) {
            this.charset = charset;
        }

        public String decode(String str) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            CodePointIterator it = new CodePointIterator(str);
            while (it.hasNext()) {
                int c = (Integer)it.next();
                if (c == 92) {
                    this.unescape(it, out);
                    continue;
                }
                ByteBuffer buf = this.charset.encode(CharBuffer.wrap(Character.toChars(c)));
                while (buf.hasRemaining()) {
                    out.write(buf.get());
                }
            }
            return new String(out.toByteArray(), this.charset);
        }

        private void unescape(Iterator<Integer> it, ByteArrayOutputStream out) {
            int c = it.next();
            switch (c) {
                case 102: {
                    out.write(12);
                    break;
                }
                case 110: {
                    out.write(10);
                    break;
                }
                case 114: {
                    out.write(13);
                    break;
                }
                case 116: {
                    out.write(9);
                    break;
                }
                case 120: {
                    int x1 = it.next();
                    int x2 = it.next();
                    out.write((Character.digit(x1, 16) << 4) + Character.digit(x2, 16));
                    break;
                }
                default: {
                    out.write(c);
                }
            }
        }
    }

    public static class Encoder {
        private final Charset charset;
        private final EncodePredicate predicate;

        private Encoder(Charset charset, EncodePredicate predicate) {
            this.charset = charset;
            this.predicate = predicate;
        }

        public String encode(String str) {
            StringBuilder out = new StringBuilder();
            for (int c : new CodePointSequence(str)) {
                if (c < 32 || c >= 127 || c == 92 || this.predicate.requiresEscape(c)) {
                    this.escape(c, out);
                    continue;
                }
                out.appendCodePoint(c);
            }
            return out.toString();
        }

        private void escape(int c, StringBuilder out) {
            switch (c) {
                case 92: {
                    out.append('\\').append('\\');
                    break;
                }
                case 12: {
                    out.append('\\').append("f");
                    break;
                }
                case 10: {
                    out.append('\\').append("n");
                    break;
                }
                case 13: {
                    out.append('\\').append("r");
                    break;
                }
                case 9: {
                    out.append('\\').append("t");
                    break;
                }
                default: {
                    ByteBuffer buf = this.charset.encode(CharBuffer.wrap(Character.toChars(c)));
                    while (buf.hasRemaining()) {
                        out.append('\\').append(String.format("x%02X", buf.get()));
                    }
                    break block0;
                }
            }
        }
    }
}

