/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TensorTypeParser {
    private static final String START_STRING = "tensor(";
    private static final String END_STRING = ")";
    private static final Pattern indexedPattern = Pattern.compile("(\\w+)\\[(\\d*)\\]");
    private static final Pattern mappedPattern = Pattern.compile("(\\w+)\\{\\}");

    public static TensorType fromSpec(String specString) {
        return new TensorType.Builder(TensorTypeParser.dimensionsFromSpec(specString)).build();
    }

    public static List<TensorType.Dimension> dimensionsFromSpec(String specString) {
        if (!specString.startsWith(START_STRING) || !specString.endsWith(END_STRING)) {
            throw new IllegalArgumentException("Tensor type spec must start with 'tensor(' and end with ')', but was '" + specString + "'");
        }
        String dimensionsSpec = specString.substring(START_STRING.length(), specString.length() - END_STRING.length());
        if (dimensionsSpec.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TensorType.Dimension> dimensions = new ArrayList<TensorType.Dimension>();
        for (String element : dimensionsSpec.split(",")) {
            boolean success;
            String trimmedElement = element.trim();
            boolean bl = success = TensorTypeParser.tryParseIndexedDimension(trimmedElement, dimensions) || TensorTypeParser.tryParseMappedDimension(trimmedElement, dimensions);
            if (success) continue;
            throw new IllegalArgumentException("Failed parsing element '" + element + "' in type spec '" + specString + "'");
        }
        return dimensions;
    }

    private static boolean tryParseIndexedDimension(String element, List<TensorType.Dimension> dimensions) {
        Matcher matcher = indexedPattern.matcher(element);
        if (matcher.matches()) {
            String dimensionName = matcher.group(1);
            String dimensionSize = matcher.group(2);
            if (dimensionSize.isEmpty()) {
                dimensions.add(TensorType.Dimension.indexed(dimensionName));
            } else {
                dimensions.add(TensorType.Dimension.indexed(dimensionName, Integer.valueOf(dimensionSize).intValue()));
            }
            return true;
        }
        return false;
    }

    private static boolean tryParseMappedDimension(String element, List<TensorType.Dimension> dimensions) {
        Matcher matcher = mappedPattern.matcher(element);
        if (matcher.matches()) {
            String dimensionName = matcher.group(1);
            dimensions.add(TensorType.Dimension.mapped(dimensionName));
            return true;
        }
        return false;
    }
}

