/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import java.util.Arrays;

public final class DimensionSizes {
    private final long[] sizes;

    private DimensionSizes(Builder builder) {
        this.sizes = builder.sizes;
        builder.sizes = null;
    }

    public long size(int dimensionIndex) {
        return this.sizes[dimensionIndex];
    }

    public int dimensions() {
        return this.sizes.length;
    }

    public long totalSize() {
        long productSize = 1L;
        for (long dimensionSize : this.sizes) {
            productSize *= dimensionSize;
        }
        return productSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionSizes)) {
            return false;
        }
        return Arrays.equals(((DimensionSizes)o).sizes, this.sizes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sizes);
    }

    public static final class Builder {
        private long[] sizes;

        public Builder(int dimensions) {
            this.sizes = new long[dimensions];
        }

        public Builder set(int dimensionIndex, long size) {
            this.sizes[dimensionIndex] = size;
            return this;
        }

        public long size(int dimensionIndex) {
            return this.sizes[dimensionIndex];
        }

        public int dimensions() {
            return this.sizes.length;
        }

        public DimensionSizes build() {
            return new DimensionSizes(this);
        }
    }
}

