/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.lang;

import java.util.NoSuchElementException;
import java.util.Optional;

public final class SettableOptional<T> {
    private T value = null;

    public SettableOptional() {
    }

    public SettableOptional(T value) {
        this.value = value;
    }

    public SettableOptional(Optional<T> value) {
        this.value = value.orElse(null);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public void set(Optional<T> value) {
        this.value = value.orElse(null);
    }

    public Optional<T> asOptional() {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }
}

