/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.objects;

import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import java.lang.reflect.Array;
import java.util.List;

public class ObjectDumper
extends ObjectVisitor {
    private final StringBuilder str = new StringBuilder();
    private final int indent;
    private int currIndent = 0;

    public ObjectDumper() {
        this(4);
    }

    public ObjectDumper(int indent) {
        this.indent = indent;
    }

    private void addIndent() {
        int n = this.currIndent;
        for (int i = 0; i < n; ++i) {
            this.str.append(' ');
        }
    }

    private void addLine(String line) {
        this.addIndent();
        this.str.append(line);
        this.str.append('\n');
    }

    private void openScope() {
        this.currIndent += this.indent;
    }

    private void closeScope() {
        this.currIndent -= this.indent;
    }

    public String toString() {
        return this.str.toString();
    }

    @Override
    public void openStruct(String name, String type) {
        if (name == null || name.isEmpty()) {
            this.addLine(type + " {");
        } else {
            this.addLine(name + ": " + type + " {");
        }
        this.openScope();
    }

    @Override
    public void closeStruct() {
        this.closeScope();
        this.addLine("}");
    }

    @Override
    public void visit(String name, Object obj) {
        if (obj == null) {
            this.addLine(name + ": <NULL>");
        } else if (obj instanceof Identifiable) {
            this.openStruct(name, obj.getClass().getSimpleName());
            ((Identifiable)obj).visitMembers(this);
            this.closeStruct();
        } else if (obj instanceof String) {
            this.addLine(name + ": '" + obj + "'");
        } else if (obj.getClass().isArray()) {
            this.openStruct(name, obj.getClass().getComponentType().getSimpleName() + "[]");
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                this.visit("[" + i + "]", Array.get(obj, i));
            }
            this.closeStruct();
        } else if (obj instanceof List) {
            this.openStruct(name, "List");
            List lst = (List)obj;
            for (int i = 0; i < lst.size(); ++i) {
                this.visit("[" + i + "]", lst.get(i));
            }
            this.closeStruct();
        } else {
            this.addLine(name + ": " + obj);
        }
    }
}

