/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.PartialAddress;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public class IndexedTensor
implements Tensor {
    private final TensorType type;
    private final DimensionSizes dimensionSizes;
    private final double[] values;

    private IndexedTensor(TensorType type, DimensionSizes dimensionSizes, double[] values) {
        this.type = type;
        this.dimensionSizes = dimensionSizes;
        this.values = values;
    }

    @Override
    public long size() {
        return this.values.length;
    }

    @Override
    public Iterator<Tensor.Cell> cellIterator() {
        return new CellIterator();
    }

    public SubspaceIterator cellIterator(PartialAddress partialAddress, DimensionSizes iterationSizes) {
        long[] startAddress = new long[this.type().dimensions().size()];
        ArrayList<Integer> iterateDimensions = new ArrayList<Integer>();
        for (int i = 0; i < this.type().dimensions().size(); ++i) {
            long partialAddressLabel = partialAddress.numericLabel(this.type.dimensions().get(i).name());
            if (partialAddressLabel >= 0L) {
                startAddress[i] = partialAddressLabel;
                continue;
            }
            iterateDimensions.add(i);
        }
        return new SubspaceIterator(iterateDimensions, startAddress, iterationSizes);
    }

    @Override
    public Iterator<Double> valueIterator() {
        return new ValueIterator();
    }

    public Iterator<SubspaceIterator> subspaceIterator(Set<String> dimensions, DimensionSizes sizes) {
        return new SuperspaceIterator(dimensions, sizes);
    }

    public Iterator<SubspaceIterator> subspaceIterator(Set<String> dimensions) {
        return this.subspaceIterator(dimensions, this.dimensionSizes);
    }

    public double get(long ... indexes) {
        return this.values[(int)IndexedTensor.toValueIndex(indexes, this.dimensionSizes)];
    }

    @Override
    public double get(TensorAddress address) {
        try {
            return this.values[(int)IndexedTensor.toValueIndex(address, this.dimensionSizes)];
        }
        catch (IndexOutOfBoundsException e) {
            return Double.NaN;
        }
    }

    public double get(long valueIndex) {
        return this.values[(int)valueIndex];
    }

    private static long toValueIndex(long[] indexes, DimensionSizes sizes) {
        if (indexes.length == 1) {
            return indexes[0];
        }
        if (indexes.length == 0) {
            return 0L;
        }
        long valueIndex = 0L;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= sizes.size(i)) {
                throw new IndexOutOfBoundsException();
            }
            valueIndex += IndexedTensor.productOfDimensionsAfter(i, sizes) * indexes[i];
        }
        return valueIndex;
    }

    private static long toValueIndex(TensorAddress address, DimensionSizes sizes) {
        if (address.isEmpty()) {
            return 0L;
        }
        long valueIndex = 0L;
        for (int i = 0; i < address.size(); ++i) {
            if (address.numericLabel(i) >= sizes.size(i)) {
                throw new IndexOutOfBoundsException();
            }
            valueIndex += IndexedTensor.productOfDimensionsAfter(i, sizes) * address.numericLabel(i);
        }
        return valueIndex;
    }

    private static long productOfDimensionsAfter(int afterIndex, DimensionSizes sizes) {
        long product = 1L;
        for (int i = afterIndex + 1; i < sizes.dimensions(); ++i) {
            product *= sizes.size(i);
        }
        return product;
    }

    @Override
    public TensorType type() {
        return this.type;
    }

    @Override
    public IndexedTensor withType(TensorType type) {
        if (!this.type.isRenamableTo(type)) {
            throw new IllegalArgumentException("IndexedTensor.withType: types are not compatible. Current type: '" + this.type.toString() + "', requested type: '" + type.toString() + "'");
        }
        return new IndexedTensor(type, this.dimensionSizes, this.values);
    }

    public DimensionSizes dimensionSizes() {
        return this.dimensionSizes;
    }

    @Override
    public Map<TensorAddress, Double> cells() {
        if (this.dimensionSizes.dimensions() == 0) {
            return Collections.singletonMap(TensorAddress.of(new long[0]), this.values[0]);
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        Indexes indexes = Indexes.of(this.dimensionSizes, this.dimensionSizes, this.values.length);
        for (long i = 0L; i < (long)this.values.length; ++i) {
            indexes.next();
            builder.put((Object)indexes.toAddress(), (Object)this.values[(int)i]);
        }
        return builder.build();
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public String toString() {
        return Tensor.toStandardString(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Tensor)) {
            return false;
        }
        return Tensor.equals(this, (Tensor)other);
    }

    private static final class EqualSizeSingleDimensionIndexes
    extends Indexes {
        private final long size;
        private final int iterateDimension;
        private long currentValueIndex;
        private final long step;

        private EqualSizeSingleDimensionIndexes(DimensionSizes sizes, int iterateDimension, long[] initialIndexes, long size) {
            super(sizes, sizes, initialIndexes);
            this.iterateDimension = iterateDimension;
            this.size = size;
            this.step = IndexedTensor.productOfDimensionsAfter(iterateDimension, sizes);
            int n = iterateDimension;
            this.indexes[n] = this.indexes[n] - 1L;
            this.currentValueIndex = IndexedTensor.toValueIndex(this.indexes, sizes);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public void next() {
            int n = this.iterateDimension;
            this.indexes[n] = this.indexes[n] + 1L;
            this.currentValueIndex += this.step;
        }

        @Override
        long toSourceValueIndex() {
            return this.currentValueIndex;
        }

        @Override
        long toIterationValueIndex() {
            return this.currentValueIndex;
        }
    }

    private static final class SingleDimensionIndexes
    extends Indexes {
        private final long size;
        private final int iterateDimension;
        private long currentSourceValueIndex;
        private long currentIterationValueIndex;
        private final long sourceStep;
        private final long iterationStep;

        private SingleDimensionIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, int iterateDimension, long[] initialIndexes, long size) {
            super(sourceSizes, iterateSizes, initialIndexes);
            this.iterateDimension = iterateDimension;
            this.size = size;
            this.sourceStep = IndexedTensor.productOfDimensionsAfter(iterateDimension, sourceSizes);
            this.iterationStep = IndexedTensor.productOfDimensionsAfter(iterateDimension, iterateSizes);
            int n = iterateDimension;
            this.indexes[n] = this.indexes[n] - 1L;
            this.currentSourceValueIndex = IndexedTensor.toValueIndex(this.indexes, sourceSizes);
            this.currentIterationValueIndex = IndexedTensor.toValueIndex(this.indexes, iterateSizes);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public void next() {
            int n = this.iterateDimension;
            this.indexes[n] = this.indexes[n] + 1L;
            this.currentSourceValueIndex += this.sourceStep;
            this.currentIterationValueIndex += this.iterationStep;
        }

        @Override
        long toSourceValueIndex() {
            return this.currentSourceValueIndex;
        }

        @Override
        long toIterationValueIndex() {
            return this.currentIterationValueIndex;
        }
    }

    private static final class EqualSizeMultiDimensionIndexes
    extends MultiDimensionIndexes {
        private long lastComputedSourceValueIndex = -1L;

        private EqualSizeMultiDimensionIndexes(DimensionSizes sizes, List<Integer> iterateDimensions, long[] initialIndexes, long size) {
            super(sizes, sizes, iterateDimensions, initialIndexes, size);
        }

        @Override
        long toSourceValueIndex() {
            this.lastComputedSourceValueIndex = super.toSourceValueIndex();
            return this.lastComputedSourceValueIndex;
        }

        @Override
        long toIterationValueIndex() {
            return this.lastComputedSourceValueIndex;
        }
    }

    private static class MultiDimensionIndexes
    extends Indexes {
        private final long size;
        private final List<Integer> iterateDimensions;

        private MultiDimensionIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, long[] initialIndexes, long size) {
            super(sourceSizes, iterateSizes, initialIndexes);
            this.iterateDimensions = iterateDimensions;
            this.size = size;
            int n = iterateDimensions.get(0);
            this.indexes[n] = this.indexes[n] - 1L;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public void next() {
            int iterateDimensionsIndex = 0;
            while (this.indexes[this.iterateDimensions.get(iterateDimensionsIndex)] + 1L == this.dimensionSizes().size(this.iterateDimensions.get(iterateDimensionsIndex))) {
                this.indexes[this.iterateDimensions.get((int)iterateDimensionsIndex).intValue()] = 0L;
                ++iterateDimensionsIndex;
            }
            int n = this.iterateDimensions.get(iterateDimensionsIndex);
            this.indexes[n] = this.indexes[n] + 1L;
        }
    }

    private static final class SingleValueIndexes
    extends Indexes {
        private SingleValueIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, long[] indexes) {
            super(sourceSizes, iterateSizes, indexes);
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void next() {
        }
    }

    private static final class EmptyIndexes
    extends Indexes {
        private EmptyIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, long[] indexes) {
            super(sourceSizes, iterateSizes, indexes);
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public void next() {
        }
    }

    public static abstract class Indexes {
        private final DimensionSizes sourceSizes;
        private final DimensionSizes iterationSizes;
        protected final long[] indexes;

        public static Indexes of(DimensionSizes sizes) {
            return Indexes.of(sizes, sizes);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes) {
            return Indexes.of(sourceSizes, iterateSizes, Indexes.completeIterationOrder(iterateSizes.dimensions()));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, long size) {
            return Indexes.of(sourceSizes, iterateSizes, Indexes.completeIterationOrder(iterateSizes.dimensions()), size);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, Indexes.computeSize(iterateSizes, iterateDimensions));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, long size) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, new long[iterateSizes.dimensions()], size);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, long[] initialIndexes) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, initialIndexes, Indexes.computeSize(iterateSizes, iterateDimensions));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, long[] initialIndexes, long size) {
            if (size == 0L) {
                return new EmptyIndexes(sourceSizes, iterateSizes, initialIndexes);
            }
            if (size == 1L) {
                return new SingleValueIndexes(sourceSizes, iterateSizes, initialIndexes);
            }
            if (iterateDimensions.size() == 1) {
                if (sourceSizes.equals(iterateSizes)) {
                    return new EqualSizeSingleDimensionIndexes(sourceSizes, iterateDimensions.get(0), initialIndexes, size);
                }
                return new SingleDimensionIndexes(sourceSizes, iterateSizes, iterateDimensions.get(0), initialIndexes, size);
            }
            if (sourceSizes.equals(iterateSizes)) {
                return new EqualSizeMultiDimensionIndexes(sourceSizes, iterateDimensions, initialIndexes, size);
            }
            return new MultiDimensionIndexes(sourceSizes, iterateSizes, iterateDimensions, initialIndexes, size);
        }

        private static List<Integer> completeIterationOrder(int length) {
            ArrayList<Integer> iterationDimensions = new ArrayList<Integer>(length);
            for (int i = 0; i < length; ++i) {
                iterationDimensions.add(length - 1 - i);
            }
            return iterationDimensions;
        }

        private Indexes(DimensionSizes sourceSizes, DimensionSizes iterationSizes, long[] indexes) {
            this.sourceSizes = sourceSizes;
            this.iterationSizes = iterationSizes;
            this.indexes = indexes;
        }

        private static long computeSize(DimensionSizes sizes, List<Integer> iterateDimensions) {
            long size = 1L;
            for (int iterateDimension : iterateDimensions) {
                size *= sizes.size(iterateDimension);
            }
            return size;
        }

        private TensorAddress toAddress() {
            return TensorAddress.of(this.indexes);
        }

        public long[] indexesCopy() {
            return Arrays.copyOf(this.indexes, this.indexes.length);
        }

        public long[] indexesForReading() {
            return this.indexes;
        }

        long toSourceValueIndex() {
            return IndexedTensor.toValueIndex(this.indexes, this.sourceSizes);
        }

        long toIterationValueIndex() {
            return IndexedTensor.toValueIndex(this.indexes, this.iterationSizes);
        }

        DimensionSizes dimensionSizes() {
            return this.iterationSizes;
        }

        public List<Long> toList() {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (long index : this.indexes) {
                builder.add((Object)index);
            }
            return builder.build();
        }

        public String toString() {
            return "indexes " + Arrays.toString(this.indexes);
        }

        public abstract long size();

        public abstract void next();
    }

    private static final class LazyCell
    extends Tensor.Cell {
        private double value;
        private Indexes indexes;

        private LazyCell(Indexes indexes, Double value) {
            super(null, value);
            this.indexes = indexes;
        }

        @Override
        long getDirectIndex() {
            return this.indexes.toIterationValueIndex();
        }

        @Override
        public TensorAddress getKey() {
            return this.indexes.toAddress();
        }

        @Override
        public Double getValue() {
            return this.value;
        }
    }

    public final class SubspaceIterator
    implements Iterator<Tensor.Cell> {
        private final List<Integer> iterateDimensions;
        private final long[] address;
        private final DimensionSizes iterateSizes;
        private Indexes indexes;
        private long count = 0L;
        private final LazyCell reusedCell;

        private SubspaceIterator(List<Integer> iterateDimensions, long[] address, DimensionSizes iterateSizes) {
            this.iterateDimensions = iterateDimensions;
            this.address = address;
            this.iterateSizes = iterateSizes;
            this.indexes = Indexes.of(IndexedTensor.this.dimensionSizes, iterateSizes, (List<Integer>)iterateDimensions, address);
            this.reusedCell = new LazyCell(this.indexes, Double.NaN);
        }

        public long size() {
            return this.indexes.size();
        }

        public TensorAddress address() {
            return this.indexes.toAddress();
        }

        public void reset() {
            this.count = 0L;
            this.indexes = Indexes.of(IndexedTensor.this.dimensionSizes, this.iterateSizes, (List<Integer>)this.iterateDimensions, this.address);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.indexes.size();
        }

        @Override
        public Tensor.Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.indexes);
            }
            ++this.count;
            this.indexes.next();
            this.reusedCell.value = IndexedTensor.this.get(this.indexes.toSourceValueIndex());
            return this.reusedCell;
        }
    }

    private final class SuperspaceIterator
    implements Iterator<SubspaceIterator> {
        private final Indexes superindexes;
        private final List<Integer> subdimensionIndexes;
        private final DimensionSizes iterateSizes;
        private long count = 0L;

        private SuperspaceIterator(Set<String> superdimensionNames, DimensionSizes iterateSizes) {
            this.iterateSizes = iterateSizes;
            ArrayList<Integer> superdimensionIndexes = new ArrayList<Integer>(superdimensionNames.size());
            this.subdimensionIndexes = new ArrayList<Integer>(superdimensionNames.size());
            for (int i = IndexedTensor.this.type.dimensions().size() - 1; i >= 0; --i) {
                if (superdimensionNames.contains(IndexedTensor.this.type.dimensions().get(i).name())) {
                    superdimensionIndexes.add(i);
                    continue;
                }
                this.subdimensionIndexes.add(i);
            }
            this.superindexes = Indexes.of(IndexedTensor.this.dimensionSizes, iterateSizes, superdimensionIndexes);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.superindexes.size();
        }

        @Override
        public SubspaceIterator next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.superindexes);
            }
            ++this.count;
            this.superindexes.next();
            return new SubspaceIterator(this.subdimensionIndexes, this.superindexes.indexesCopy(), this.iterateSizes);
        }
    }

    private final class ValueIterator
    implements Iterator<Double> {
        private long count = 0L;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < (long)IndexedTensor.this.values.length;
        }

        @Override
        public Double next() {
            try {
                return IndexedTensor.this.values[(int)this.count++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("No element at position " + this.count);
            }
        }
    }

    private final class CellIterator
    implements Iterator<Tensor.Cell> {
        private long count = 0L;
        private final Indexes indexes = Indexes.access$400(IndexedTensor.access$1400(IndexedTensor.this), IndexedTensor.access$1400(IndexedTensor.this), IndexedTensor.access$1500(IndexedTensor.this).length);
        private final LazyCell reusedCell = new LazyCell(this.indexes, Double.NaN);

        private CellIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < this.indexes.size();
        }

        @Override
        public Tensor.Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.indexes);
            }
            ++this.count;
            this.indexes.next();
            this.reusedCell.value = IndexedTensor.this.get(this.indexes.toSourceValueIndex());
            return this.reusedCell;
        }
    }

    private static class UnboundBuilder
    extends Builder {
        private List<Object> firstDimension = null;

        private UnboundBuilder(TensorType type) {
            super(type);
        }

        @Override
        public IndexedTensor build() {
            if (this.firstDimension == null) {
                throw new IllegalArgumentException("Tensor of type " + this.type() + " has no values");
            }
            if (this.type.dimensions().isEmpty()) {
                return new IndexedTensor(this.type, new DimensionSizes.Builder(this.type.dimensions().size()).build(), new double[]{(Double)this.firstDimension.get(0)});
            }
            DimensionSizes dimensionSizes = this.findDimensionSizes(this.firstDimension);
            double[] values = new double[(int)dimensionSizes.totalSize()];
            this.fillValues(0, 0L, this.firstDimension, dimensionSizes, values);
            return new IndexedTensor(this.type, dimensionSizes, values);
        }

        private DimensionSizes findDimensionSizes(List<Object> firstDimension) {
            ArrayList<Long> dimensionSizeList = new ArrayList<Long>(this.type.dimensions().size());
            this.findDimensionSizes(0, dimensionSizeList, firstDimension);
            DimensionSizes.Builder b = new DimensionSizes.Builder(this.type.dimensions().size());
            for (int i = 0; i < b.dimensions(); ++i) {
                if (i >= dimensionSizeList.size()) continue;
                b.set(i, (Long)dimensionSizeList.get(i));
            }
            return b.build();
        }

        private void findDimensionSizes(int currentDimensionIndex, List<Long> dimensionSizes, List<Object> currentDimension) {
            if (currentDimensionIndex == dimensionSizes.size()) {
                dimensionSizes.add(Long.valueOf(currentDimension.size()));
            } else if (dimensionSizes.get(currentDimensionIndex) != (long)currentDimension.size()) {
                throw new IllegalArgumentException("Missing values in dimension " + this.type.dimensions().get(currentDimensionIndex) + " in " + this.type);
            }
            for (Object value : currentDimension) {
                if (!(value instanceof List)) continue;
                this.findDimensionSizes(currentDimensionIndex + 1, dimensionSizes, (List)value);
            }
        }

        private void fillValues(int currentDimensionIndex, long offset, List<Object> currentDimension, DimensionSizes sizes, double[] values) {
            if (currentDimensionIndex < sizes.dimensions() - 1) {
                for (long i = 0L; i < (long)currentDimension.size(); ++i) {
                    this.fillValues(currentDimensionIndex + 1, offset + IndexedTensor.productOfDimensionsAfter(currentDimensionIndex, sizes) * i, (List)currentDimension.get((int)i), sizes, values);
                }
            } else {
                for (long i = 0L; i < (long)currentDimension.size(); ++i) {
                    values[(int)(offset + i)] = this.nullAsZero((Double)currentDimension.get((int)i));
                }
            }
        }

        private double nullAsZero(Double value) {
            if (value == null) {
                return 0.0;
            }
            return value;
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type, this);
        }

        @Override
        public Builder cell(TensorAddress address, double value) {
            long[] indexes = new long[address.size()];
            for (int i = 0; i < address.size(); ++i) {
                indexes[i] = address.numericLabel(i);
            }
            this.cell(value, indexes);
            return this;
        }

        @Override
        public Builder cell(double value, long ... indexes) {
            if (indexes.length != this.type.dimensions().size()) {
                throw new IllegalArgumentException("Wrong number of indexes (" + indexes.length + ") for " + this.type);
            }
            if (indexes.length == 0) {
                this.firstDimension = Collections.singletonList(value);
                return this;
            }
            if (this.firstDimension == null) {
                this.firstDimension = new ArrayList<Object>();
            }
            List currentValues = this.firstDimension;
            for (int dimensionIndex = 0; dimensionIndex < indexes.length; ++dimensionIndex) {
                this.ensureCapacity(indexes[dimensionIndex], currentValues);
                if (dimensionIndex == indexes.length - 1) {
                    currentValues.set((int)indexes[dimensionIndex], value);
                    continue;
                }
                if (currentValues.get((int)indexes[dimensionIndex]) == null) {
                    currentValues.set((int)indexes[dimensionIndex], new ArrayList());
                }
                currentValues = (List)currentValues.get((int)indexes[dimensionIndex]);
            }
            return this;
        }

        private void ensureCapacity(long index, List<Object> list) {
            while ((long)list.size() <= index) {
                list.add(list.size(), null);
            }
        }
    }

    public static class BoundBuilder
    extends Builder {
        private DimensionSizes sizes;
        private double[] values;

        private BoundBuilder(TensorType type) {
            this(type, BoundBuilder.dimensionSizesOf(type));
        }

        static DimensionSizes dimensionSizesOf(TensorType type) {
            DimensionSizes.Builder b = new DimensionSizes.Builder(type.dimensions().size());
            for (int i = 0; i < type.dimensions().size(); ++i) {
                b.set(i, type.dimensions().get(i).size().get());
            }
            return b.build();
        }

        private BoundBuilder(TensorType type, DimensionSizes sizes) {
            super(type);
            if (sizes.dimensions() != type.dimensions().size()) {
                throw new IllegalArgumentException("Must have a dimension size entry for each dimension in " + type);
            }
            this.sizes = sizes;
            this.values = new double[(int)sizes.totalSize()];
        }

        @Override
        public BoundBuilder cell(double value, long ... indexes) {
            this.values[(int)IndexedTensor.toValueIndex((long[])indexes, (DimensionSizes)this.sizes)] = value;
            return this;
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type, this);
        }

        @Override
        public Builder cell(TensorAddress address, double value) {
            this.values[(int)IndexedTensor.toValueIndex((TensorAddress)address, (DimensionSizes)this.sizes)] = value;
            return this;
        }

        @Override
        public IndexedTensor build() {
            IndexedTensor tensor = new IndexedTensor(this.type, this.sizes, this.values);
            this.sizes = null;
            this.values = null;
            return tensor;
        }

        @Override
        public Builder cell(Tensor.Cell cell, double value) {
            long directIndex = cell.getDirectIndex();
            if (directIndex >= 0L) {
                this.values[(int)directIndex] = value;
            } else {
                super.cell(cell, value);
            }
            return this;
        }

        public void cellByDirectIndex(long index, double value) {
            this.values[(int)index] = value;
        }
    }

    public static abstract class Builder
    implements Tensor.Builder {
        final TensorType type;

        private Builder(TensorType type) {
            this.type = type;
        }

        public static Builder of(TensorType type) {
            if (type.dimensions().stream().allMatch(d -> d instanceof TensorType.IndexedBoundDimension)) {
                return new BoundBuilder(type);
            }
            return new UnboundBuilder(type);
        }

        public static Builder of(TensorType type, DimensionSizes sizes) {
            if (sizes.dimensions() != type.dimensions().size()) {
                throw new IllegalArgumentException(sizes.dimensions() + " is the wrong number of dimensions for " + type);
            }
            for (int i = 0; i < sizes.dimensions(); ++i) {
                Optional<Long> size = type.dimensions().get(i).size();
                if (!size.isPresent() || size.get() >= sizes.size(i)) continue;
                throw new IllegalArgumentException("Size of dimension " + type.dimensions().get(i).name() + " is " + sizes.size(i) + " but cannot be larger than " + size.get() + " in " + type);
            }
            return new BoundBuilder(type, sizes);
        }

        @Override
        public abstract Builder cell(double var1, long ... var3);

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public abstract IndexedTensor build();
    }
}

