/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.TensorTypeParser;
import java.util.Optional;

class TensorParser {
    TensorParser() {
    }

    static Tensor tensorFrom(String tensorString, Optional<TensorType> type) {
        tensorString = tensorString.trim();
        try {
            if (tensorString.startsWith("tensor(")) {
                int colonIndex = tensorString.indexOf(58);
                String typeString = tensorString.substring(0, colonIndex);
                String valueString = tensorString.substring(colonIndex + 1);
                TensorType typeFromString = TensorTypeParser.fromSpec(typeString);
                if (type.isPresent() && !type.get().equals(typeFromString)) {
                    throw new IllegalArgumentException("Got tensor with type string '" + typeString + "', but was passed type " + type);
                }
                return TensorParser.tensorFromValueString(valueString, typeFromString);
            }
            if (tensorString.startsWith("{")) {
                return TensorParser.tensorFromValueString(tensorString, type.orElse(TensorParser.typeFromValueString(tensorString)));
            }
            if (type.isPresent() && !type.get().equals(TensorType.empty)) {
                throw new IllegalArgumentException("Got zero-dimensional tensor '" + tensorString + "' where type " + type.get() + " is required");
            }
            return Tensor.Builder.of(TensorType.empty).cell(Double.parseDouble(tensorString), new long[0]).build();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Excepted a number or a string starting by { or tensor(, got '" + tensorString + "'");
        }
    }

    private static TensorType typeFromValueString(String s) {
        int firstKeyOrTensorEnd;
        String addressBody = (s = s.substring(1).trim()).substring(0, firstKeyOrTensorEnd = s.indexOf(125)).trim();
        if (addressBody.isEmpty()) {
            return TensorType.empty;
        }
        if (!addressBody.startsWith("{")) {
            return TensorType.empty;
        }
        if ((addressBody = addressBody.substring(1)).isEmpty()) {
            return TensorType.empty;
        }
        TensorType.Builder builder = new TensorType.Builder();
        for (String elementString : addressBody.split(",")) {
            String[] pair = elementString.split(":");
            if (pair.length != 2) {
                throw new IllegalArgumentException("Expecting argument elements to be on the form dimension:label, got '" + elementString + "'");
            }
            builder.mapped(pair[0].trim());
        }
        return builder.build();
    }

    private static Tensor tensorFromValueString(String tensorValueString, TensorType type) {
        Tensor.Builder builder = Tensor.Builder.of(type);
        tensorValueString = tensorValueString.trim();
        try {
            if (tensorValueString.startsWith("{")) {
                return TensorParser.fromCellString(builder, tensorValueString);
            }
            return builder.cell(Double.parseDouble(tensorValueString), new long[0]).build();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Excepted a number or a string starting by { or tensor(, got '" + tensorValueString + "'");
        }
    }

    private static Tensor fromCellString(Tensor.Builder builder, String s) {
        s = s.trim().substring(1).trim();
        while (s.length() > 1) {
            int valueEnd;
            int keyOrTensorEnd = s.indexOf(125);
            TensorAddress.Builder addressBuilder = new TensorAddress.Builder(builder.type());
            if (keyOrTensorEnd < s.length() - 1) {
                TensorParser.addLabels(s.substring(0, keyOrTensorEnd + 1), addressBuilder);
                s = s.substring(keyOrTensorEnd + 1).trim();
                if (!s.startsWith(":")) {
                    throw new IllegalArgumentException("Expecting a ':' after " + s + ", got '" + s + "'");
                }
                s = s.substring(1);
            }
            if ((valueEnd = s.indexOf(44)) < 0 && (valueEnd = s.indexOf("}")) < 0) {
                throw new IllegalArgumentException("A tensor string must end by '}'");
            }
            TensorAddress address = addressBuilder.build();
            Double value = TensorParser.asDouble(address, s.substring(0, valueEnd).trim());
            builder.cell(address, (double)value);
            s = s.substring(valueEnd + 1).trim();
        }
        return builder.build();
    }

    private static void addLabels(String mapAddressString, TensorAddress.Builder builder) {
        if (!(mapAddressString = mapAddressString.trim()).startsWith("{") || !mapAddressString.endsWith("}")) {
            throw new IllegalArgumentException("Expecting a tensor address enclosed in {}, got '" + mapAddressString + "'");
        }
        String addressBody = mapAddressString.substring(1, mapAddressString.length() - 1).trim();
        if (addressBody.isEmpty()) {
            return;
        }
        for (String elementString : addressBody.split(",")) {
            String[] pair = elementString.split(":");
            if (pair.length != 2) {
                throw new IllegalArgumentException("Expecting argument elements on the form dimension:label, got '" + elementString + "'");
            }
            String dimension = pair[0].trim();
            builder.add(dimension, pair[1].trim());
        }
    }

    private static Double asDouble(TensorAddress address, String s) {
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("At " + address + ": Expected a floating point number, got '" + s + "'");
        }
    }
}

