/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.NixValue;
import com.yahoo.slime.Type;
import com.yahoo.slime.Utf8Codec;
import com.yahoo.slime.Value;
import com.yahoo.slime.Visitor;

final class Utf8Value
extends Value {
    private final byte[] value;
    private String string;

    private Utf8Value(byte[] value) {
        this.value = value;
    }

    public static Value create(byte[] value) {
        if (value == null) {
            return NixValue.instance();
        }
        return new Utf8Value(value);
    }

    @Override
    public final Type type() {
        return Type.STRING;
    }

    @Override
    public final String asString() {
        if (this.string == null) {
            this.string = Utf8Codec.decode(this.value, 0, this.value.length);
        }
        return this.string;
    }

    @Override
    public final byte[] asUtf8() {
        return this.value;
    }

    @Override
    public final void accept(Visitor v) {
        v.visitString(this.value);
    }
}

