/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;

public class Argmax
extends CompositeTensorFunction {
    private final TensorFunction argument;
    private final String dimension;

    public Argmax(TensorFunction argument, String dimension) {
        this.argument = argument;
        this.dimension = dimension;
    }

    @Override
    public List<TensorFunction> arguments() {
        return Collections.singletonList(this.argument);
    }

    @Override
    public TensorFunction withArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Argmax must have 1 argument, got " + arguments.size());
        }
        return new Argmax(arguments.get(0), this.dimension);
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        PrimitiveTensorFunction primitiveArgument = this.argument.toPrimitive();
        return new Join(primitiveArgument, new Reduce((TensorFunction)primitiveArgument, Reduce.Aggregator.max, this.dimension), ScalarFunctions.equal());
    }

    @Override
    public String toString(ToStringContext context) {
        return "argmax(" + this.argument.toString(context) + ", " + this.dimension + ")";
    }
}

