/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.path;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@Beta
public final class Path {
    private final String delimiter;
    private final ImmutableList<String> elements;

    private Path(String delimiter) {
        this(new ArrayList<String>(), delimiter);
    }

    private Path(Path rhs) {
        this((List<String>)rhs.elements, rhs.delimiter);
    }

    private Path(List<String> elements, String delimiter) {
        this.elements = ImmutableList.copyOf(elements);
        this.delimiter = delimiter;
    }

    public boolean isChildOf(Path parent) {
        return this.toString().startsWith(parent.toString()) && this.elements.size() - 1 == parent.elements.size();
    }

    private static List<String> elementsOf(String path, String delimiter) {
        return Arrays.stream(path.split(delimiter)).filter(e -> !"".equals(e)).collect(Collectors.toList());
    }

    public Path append(String path) {
        ArrayList<String> newElements = new ArrayList<String>((Collection<String>)this.elements);
        newElements.addAll(Path.elementsOf(path, this.delimiter));
        return new Path(newElements, this.delimiter);
    }

    public Path append(Path path) {
        ArrayList<String> newElements = new ArrayList<String>((Collection<String>)this.elements);
        newElements.addAll(path.elements());
        return new Path(newElements, this.delimiter);
    }

    public String getName() {
        if (this.elements.isEmpty()) {
            return "";
        }
        return (String)this.elements.get(this.elements.size() - 1);
    }

    public String getRelative() {
        if (this.elements.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((String)this.elements.get(0));
        for (int i = 1; i < this.elements.size(); ++i) {
            sb.append(this.delimiter);
            sb.append((String)this.elements.get(i));
        }
        return sb.toString();
    }

    public Path getParentPath() {
        ArrayList<String> parentElements = new ArrayList<String>();
        if (this.elements.size() > 1) {
            for (int i = 0; i < this.elements.size() - 1; ++i) {
                parentElements.add((String)this.elements.get(i));
            }
        }
        return new Path(parentElements, this.delimiter);
    }

    public String getAbsolute() {
        return this.delimiter + this.getRelative();
    }

    public boolean isRoot() {
        return this.elements.isEmpty();
    }

    public Iterator<String> iterator() {
        return this.elements.iterator();
    }

    public List<String> elements() {
        return this.elements;
    }

    public String toString() {
        return this.getRelative();
    }

    public static Path fromString(String path) {
        return Path.fromString(path, "/");
    }

    public static Path fromString(String path, String delimiter) {
        return new Path(Path.elementsOf(path, delimiter), delimiter);
    }

    public static Path createRoot() {
        return Path.createRoot("/");
    }

    public static Path createRoot(String delimiter) {
        return new Path(delimiter);
    }

    public File toFile() {
        return new File(this.toString());
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Path) {
            return this.getRelative().equals(((Path)other).getRelative());
        }
        return false;
    }
}

