/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.util.OptionalInt;

public final class Text {
    private static final boolean[] allowedAsciiChars;

    private Text() {
    }

    public static boolean isTextCharacter(int codepoint) {
        if (codepoint < 128) {
            return allowedAsciiChars[codepoint];
        }
        if (codepoint < 64976) {
            return true;
        }
        if (codepoint <= 64991) {
            return false;
        }
        if (codepoint < 131070) {
            return true;
        }
        if (codepoint <= 131071) {
            return false;
        }
        if (codepoint < 196606) {
            return true;
        }
        if (codepoint <= 196607) {
            return false;
        }
        if (codepoint < 262142) {
            return true;
        }
        if (codepoint <= 262143) {
            return false;
        }
        if (codepoint < 327678) {
            return true;
        }
        if (codepoint <= 327679) {
            return false;
        }
        if (codepoint < 393214) {
            return true;
        }
        if (codepoint <= 393215) {
            return false;
        }
        if (codepoint < 458750) {
            return true;
        }
        if (codepoint <= 458751) {
            return false;
        }
        if (codepoint < 524286) {
            return true;
        }
        if (codepoint <= 524287) {
            return false;
        }
        if (codepoint < 589822) {
            return true;
        }
        if (codepoint <= 589823) {
            return false;
        }
        if (codepoint < 655358) {
            return true;
        }
        if (codepoint <= 655359) {
            return false;
        }
        if (codepoint < 720894) {
            return true;
        }
        if (codepoint <= 720895) {
            return false;
        }
        if (codepoint < 786430) {
            return true;
        }
        if (codepoint <= 786431) {
            return false;
        }
        if (codepoint < 851966) {
            return true;
        }
        if (codepoint <= 851967) {
            return false;
        }
        if (codepoint < 917502) {
            return true;
        }
        if (codepoint <= 917503) {
            return false;
        }
        if (codepoint < 983038) {
            return true;
        }
        if (codepoint <= 983039) {
            return false;
        }
        if (codepoint < 1048574) {
            return true;
        }
        if (codepoint <= 1048575) {
            return false;
        }
        if (codepoint < 1114110) {
            return true;
        }
        return codepoint > 0x10FFFF;
    }

    public static OptionalInt validateTextString(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char theChar = value.charAt(i);
            int codePoint = value.codePointAt(i);
            if (Character.isHighSurrogate(theChar)) {
                ++i;
            }
            if (Text.isTextCharacter(codePoint)) continue;
            return OptionalInt.of(codePoint);
        }
        return OptionalInt.empty();
    }

    static {
        int i;
        allowedAsciiChars = new boolean[128];
        Text.allowedAsciiChars[0] = false;
        Text.allowedAsciiChars[1] = false;
        Text.allowedAsciiChars[2] = false;
        Text.allowedAsciiChars[3] = false;
        Text.allowedAsciiChars[4] = false;
        Text.allowedAsciiChars[5] = false;
        Text.allowedAsciiChars[6] = false;
        Text.allowedAsciiChars[7] = false;
        Text.allowedAsciiChars[8] = false;
        Text.allowedAsciiChars[9] = true;
        Text.allowedAsciiChars[10] = true;
        Text.allowedAsciiChars[11] = false;
        Text.allowedAsciiChars[12] = false;
        Text.allowedAsciiChars[13] = true;
        for (i = 14; i < 32; ++i) {
            Text.allowedAsciiChars[i] = false;
        }
        for (i = 32; i < 127; ++i) {
            Text.allowedAsciiChars[i] = true;
        }
        Text.allowedAsciiChars[127] = true;
    }
}

