/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.serialization;

import com.google.common.annotations.Beta;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.BinaryFormat;
import java.util.Iterator;
import java.util.Optional;

@Beta
public class DenseBinaryFormat
implements BinaryFormat {
    @Override
    public void encode(GrowableByteBuffer buffer, Tensor tensor) {
        if (!(tensor instanceof IndexedTensor)) {
            throw new RuntimeException("The dense format is only supported for indexed tensors");
        }
        this.encodeDimensions(buffer, (IndexedTensor)tensor);
        this.encodeCells(buffer, tensor);
    }

    private void encodeDimensions(GrowableByteBuffer buffer, IndexedTensor tensor) {
        buffer.putInt1_4Bytes(tensor.type().dimensions().size());
        for (int i = 0; i < tensor.type().dimensions().size(); ++i) {
            buffer.putUtf8String(tensor.type().dimensions().get(i).name());
            buffer.putInt1_4Bytes(tensor.dimensionSizes().size(i));
        }
    }

    private void encodeCells(GrowableByteBuffer buffer, Tensor tensor) {
        Iterator<Double> i = tensor.valueIterator();
        while (i.hasNext()) {
            buffer.putDouble(i.next());
        }
    }

    @Override
    public Tensor decode(Optional<TensorType> optionalType, GrowableByteBuffer buffer) {
        DimensionSizes sizes;
        TensorType type;
        if (optionalType.isPresent()) {
            type = optionalType.get();
            TensorType serializedType = this.decodeType(buffer);
            if (!serializedType.isAssignableTo(type)) {
                throw new IllegalArgumentException("Type/instance mismatch: A tensor of type " + serializedType + " cannot be assigned to type " + type);
            }
            sizes = this.sizesFromType(serializedType);
        } else {
            type = this.decodeType(buffer);
            sizes = this.sizesFromType(type);
        }
        Tensor.Builder builder = Tensor.Builder.of(type, sizes);
        this.decodeCells(sizes, buffer, (IndexedTensor.BoundBuilder)builder);
        return builder.build();
    }

    private TensorType decodeType(GrowableByteBuffer buffer) {
        int dimensionCount = buffer.getInt1_4Bytes();
        TensorType.Builder builder = new TensorType.Builder();
        for (int i = 0; i < dimensionCount; ++i) {
            builder.indexed(buffer.getUtf8String(), buffer.getInt1_4Bytes());
        }
        return builder.build();
    }

    private DimensionSizes sizesFromType(TensorType type) {
        DimensionSizes.Builder builder = new DimensionSizes.Builder(type.dimensions().size());
        for (int i = 0; i < type.dimensions().size(); ++i) {
            builder.set(i, type.dimensions().get(i).size().get());
        }
        return builder.build();
    }

    private void decodeCells(DimensionSizes sizes, GrowableByteBuffer buffer, IndexedTensor.BoundBuilder builder) {
        for (int i = 0; i < sizes.totalSize(); ++i) {
            builder.cellByDirectIndex(i, buffer.getDouble());
        }
    }
}

