/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.PartialAddress;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

@Beta
public class IndexedTensor
implements Tensor {
    private final TensorType type;
    private final DimensionSizes dimensionSizes;
    private final double[] values;

    private IndexedTensor(TensorType type, DimensionSizes dimensionSizes, double[] values) {
        this.type = type;
        this.dimensionSizes = dimensionSizes;
        this.values = values;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Iterator<Tensor.Cell> cellIterator() {
        return new CellIterator();
    }

    public SubspaceIterator cellIterator(PartialAddress partialAddress, DimensionSizes iterationSizes) {
        int[] startAddress = new int[this.type().dimensions().size()];
        ArrayList<Integer> iterateDimensions = new ArrayList<Integer>();
        for (int i = 0; i < this.type().dimensions().size(); ++i) {
            int partialAddressLabel = partialAddress.intLabel(this.type.dimensions().get(i).name());
            if (partialAddressLabel >= 0) {
                startAddress[i] = partialAddressLabel;
                continue;
            }
            iterateDimensions.add(i);
        }
        return new SubspaceIterator(iterateDimensions, startAddress, iterationSizes);
    }

    @Override
    public Iterator<Double> valueIterator() {
        return new ValueIterator();
    }

    public Iterator<SubspaceIterator> subspaceIterator(Set<String> dimensions, DimensionSizes sizes) {
        return new SuperspaceIterator(dimensions, sizes);
    }

    public Iterator<SubspaceIterator> subspaceIterator(Set<String> dimensions) {
        return this.subspaceIterator(dimensions, this.dimensionSizes);
    }

    public double get(int ... indexes) {
        return this.values[IndexedTensor.toValueIndex(indexes, this.dimensionSizes)];
    }

    @Override
    public double get(TensorAddress address) {
        try {
            return this.values[IndexedTensor.toValueIndex(address, this.dimensionSizes)];
        }
        catch (IndexOutOfBoundsException e) {
            return Double.NaN;
        }
    }

    private double get(int valueIndex) {
        return this.values[valueIndex];
    }

    private static int toValueIndex(int[] indexes, DimensionSizes sizes) {
        if (indexes.length == 1) {
            return indexes[0];
        }
        if (indexes.length == 0) {
            return 0;
        }
        int valueIndex = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= sizes.size(i)) {
                throw new IndexOutOfBoundsException();
            }
            valueIndex += IndexedTensor.productOfDimensionsAfter(i, sizes) * indexes[i];
        }
        return valueIndex;
    }

    private static int toValueIndex(TensorAddress address, DimensionSizes sizes) {
        if (address.isEmpty()) {
            return 0;
        }
        int valueIndex = 0;
        for (int i = 0; i < address.size(); ++i) {
            if (address.intLabel(i) >= sizes.size(i)) {
                throw new IndexOutOfBoundsException();
            }
            valueIndex += IndexedTensor.productOfDimensionsAfter(i, sizes) * address.intLabel(i);
        }
        return valueIndex;
    }

    private static int productOfDimensionsAfter(int afterIndex, DimensionSizes sizes) {
        int product = 1;
        for (int i = afterIndex + 1; i < sizes.dimensions(); ++i) {
            product *= sizes.size(i);
        }
        return product;
    }

    @Override
    public TensorType type() {
        return this.type;
    }

    public DimensionSizes dimensionSizes() {
        return this.dimensionSizes;
    }

    @Override
    public Map<TensorAddress, Double> cells() {
        if (this.dimensionSizes.dimensions() == 0) {
            return Collections.singletonMap(TensorAddress.of(new int[0]), this.values[0]);
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        Indexes indexes = Indexes.of(this.dimensionSizes, this.dimensionSizes, this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            indexes.next();
            builder.put((Object)indexes.toAddress(), (Object)this.values[i]);
        }
        return builder.build();
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public String toString() {
        return Tensor.toStandardString(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Tensor)) {
            return false;
        }
        return Tensor.equals(this, (Tensor)other);
    }

    private static final class EqualSizeSingleDimensionIndexes
    extends Indexes {
        private final int size;
        private final int iterateDimension;
        private int currentValueIndex;
        private final int step;

        private EqualSizeSingleDimensionIndexes(DimensionSizes sizes, int iterateDimension, int[] initialIndexes, int size) {
            super(sizes, sizes, initialIndexes);
            this.iterateDimension = iterateDimension;
            this.size = size;
            this.step = IndexedTensor.productOfDimensionsAfter(iterateDimension, sizes);
            int n = iterateDimension;
            this.indexes[n] = this.indexes[n] - 1;
            this.currentValueIndex = IndexedTensor.toValueIndex(this.indexes, sizes);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void next() {
            int n = this.iterateDimension;
            this.indexes[n] = this.indexes[n] + 1;
            this.currentValueIndex += this.step;
        }

        @Override
        int toSourceValueIndex() {
            return this.currentValueIndex;
        }

        @Override
        int toIterationValueIndex() {
            return this.currentValueIndex;
        }
    }

    private static final class SingleDimensionIndexes
    extends Indexes {
        private final int size;
        private final int iterateDimension;
        private int currentSourceValueIndex;
        private int currentIterationValueIndex;
        private final int sourceStep;
        private final int iterationStep;

        private SingleDimensionIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, int iterateDimension, int[] initialIndexes, int size) {
            super(sourceSizes, iterateSizes, initialIndexes);
            this.iterateDimension = iterateDimension;
            this.size = size;
            this.sourceStep = IndexedTensor.productOfDimensionsAfter(iterateDimension, sourceSizes);
            this.iterationStep = IndexedTensor.productOfDimensionsAfter(iterateDimension, iterateSizes);
            int n = iterateDimension;
            this.indexes[n] = this.indexes[n] - 1;
            this.currentSourceValueIndex = IndexedTensor.toValueIndex(this.indexes, sourceSizes);
            this.currentIterationValueIndex = IndexedTensor.toValueIndex(this.indexes, iterateSizes);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void next() {
            int n = this.iterateDimension;
            this.indexes[n] = this.indexes[n] + 1;
            this.currentSourceValueIndex += this.sourceStep;
            this.currentIterationValueIndex += this.iterationStep;
        }

        @Override
        int toSourceValueIndex() {
            return this.currentSourceValueIndex;
        }

        @Override
        int toIterationValueIndex() {
            return this.currentIterationValueIndex;
        }
    }

    private static final class EqualSizeMultiDimensionIndexes
    extends MultiDimensionIndexes {
        private int lastComputedSourceValueIndex = -1;

        private EqualSizeMultiDimensionIndexes(DimensionSizes sizes, List<Integer> iterateDimensions, int[] initialIndexes, int size) {
            super(sizes, sizes, iterateDimensions, initialIndexes, size);
        }

        @Override
        int toSourceValueIndex() {
            this.lastComputedSourceValueIndex = super.toSourceValueIndex();
            return this.lastComputedSourceValueIndex;
        }

        @Override
        int toIterationValueIndex() {
            return this.lastComputedSourceValueIndex;
        }
    }

    private static class MultiDimensionIndexes
    extends Indexes {
        private final int size;
        private final List<Integer> iterateDimensions;

        private MultiDimensionIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, int[] initialIndexes, int size) {
            super(sourceSizes, iterateSizes, initialIndexes);
            this.iterateDimensions = iterateDimensions;
            this.size = size;
            int n = iterateDimensions.get(0);
            this.indexes[n] = this.indexes[n] - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void next() {
            int iterateDimensionsIndex = 0;
            while (this.indexes[this.iterateDimensions.get(iterateDimensionsIndex)] + 1 == this.dimensionSizes().size(this.iterateDimensions.get(iterateDimensionsIndex))) {
                this.indexes[this.iterateDimensions.get((int)iterateDimensionsIndex).intValue()] = 0;
                ++iterateDimensionsIndex;
            }
            int n = this.iterateDimensions.get(iterateDimensionsIndex);
            this.indexes[n] = this.indexes[n] + 1;
        }
    }

    private static final class SingleValueIndexes
    extends Indexes {
        private SingleValueIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, int[] indexes) {
            super(sourceSizes, iterateSizes, indexes);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void next() {
        }
    }

    private static final class EmptyIndexes
    extends Indexes {
        private EmptyIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, int[] indexes) {
            super(sourceSizes, iterateSizes, indexes);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void next() {
        }
    }

    public static abstract class Indexes {
        private final DimensionSizes sourceSizes;
        private final DimensionSizes iterationSizes;
        protected final int[] indexes;

        public static Indexes of(DimensionSizes sizes) {
            return Indexes.of(sizes, sizes);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes) {
            return Indexes.of(sourceSizes, iterateSizes, Indexes.completeIterationOrder(iterateSizes.dimensions()));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, int size) {
            return Indexes.of(sourceSizes, iterateSizes, Indexes.completeIterationOrder(iterateSizes.dimensions()), size);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, Indexes.computeSize(iterateSizes, iterateDimensions));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, int size) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, new int[iterateSizes.dimensions()], size);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, int[] initialIndexes) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, initialIndexes, Indexes.computeSize(iterateSizes, iterateDimensions));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, int[] initialIndexes, int size) {
            if (size == 0) {
                return new EmptyIndexes(sourceSizes, iterateSizes, initialIndexes);
            }
            if (size == 1) {
                return new SingleValueIndexes(sourceSizes, iterateSizes, initialIndexes);
            }
            if (iterateDimensions.size() == 1) {
                if (sourceSizes.equals(iterateSizes)) {
                    return new EqualSizeSingleDimensionIndexes(sourceSizes, iterateDimensions.get(0), initialIndexes, size);
                }
                return new SingleDimensionIndexes(sourceSizes, iterateSizes, iterateDimensions.get(0), initialIndexes, size);
            }
            if (sourceSizes.equals(iterateSizes)) {
                return new EqualSizeMultiDimensionIndexes(sourceSizes, iterateDimensions, initialIndexes, size);
            }
            return new MultiDimensionIndexes(sourceSizes, iterateSizes, iterateDimensions, initialIndexes, size);
        }

        private static List<Integer> completeIterationOrder(int length) {
            ArrayList<Integer> iterationDimensions = new ArrayList<Integer>(length);
            for (int i = 0; i < length; ++i) {
                iterationDimensions.add(length - 1 - i);
            }
            return iterationDimensions;
        }

        private Indexes(DimensionSizes sourceSizes, DimensionSizes iterationSizes, int[] indexes) {
            this.sourceSizes = sourceSizes;
            this.iterationSizes = iterationSizes;
            this.indexes = indexes;
        }

        private static int computeSize(DimensionSizes sizes, List<Integer> iterateDimensions) {
            int size = 1;
            for (int iterateDimension : iterateDimensions) {
                size *= sizes.size(iterateDimension);
            }
            return size;
        }

        private TensorAddress toAddress() {
            return TensorAddress.of(this.indexes);
        }

        public int[] indexesCopy() {
            return Arrays.copyOf(this.indexes, this.indexes.length);
        }

        public int[] indexesForReading() {
            return this.indexes;
        }

        int toSourceValueIndex() {
            return IndexedTensor.toValueIndex(this.indexes, this.sourceSizes);
        }

        int toIterationValueIndex() {
            return IndexedTensor.toValueIndex(this.indexes, this.iterationSizes);
        }

        DimensionSizes dimensionSizes() {
            return this.iterationSizes;
        }

        public List<Integer> toList() {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (int index : this.indexes) {
                builder.add((Object)index);
            }
            return builder.build();
        }

        public String toString() {
            return "indexes " + Arrays.toString(this.indexes);
        }

        public abstract int size();

        public abstract void next();
    }

    private static final class LazyCell
    extends Tensor.Cell {
        private double value;
        private Indexes indexes;

        private LazyCell(Indexes indexes, Double value) {
            super(null, value);
            this.indexes = indexes;
        }

        @Override
        int getDirectIndex() {
            return this.indexes.toIterationValueIndex();
        }

        @Override
        public TensorAddress getKey() {
            return this.indexes.toAddress();
        }

        @Override
        public Double getValue() {
            return this.value;
        }
    }

    public final class SubspaceIterator
    implements Iterator<Tensor.Cell> {
        private final List<Integer> iterateDimensions;
        private final int[] address;
        private final DimensionSizes iterateSizes;
        private Indexes indexes;
        private int count = 0;
        private final LazyCell reusedCell;

        private SubspaceIterator(List<Integer> iterateDimensions, int[] address, DimensionSizes iterateSizes) {
            this.iterateDimensions = iterateDimensions;
            this.address = address;
            this.iterateSizes = iterateSizes;
            this.indexes = Indexes.of(IndexedTensor.this.dimensionSizes, iterateSizes, (List<Integer>)iterateDimensions, address);
            this.reusedCell = new LazyCell(this.indexes, Double.NaN);
        }

        public int size() {
            return this.indexes.size();
        }

        public TensorAddress address() {
            return this.indexes.toAddress();
        }

        public void reset() {
            this.count = 0;
            this.indexes = Indexes.of(IndexedTensor.this.dimensionSizes, this.iterateSizes, (List<Integer>)this.iterateDimensions, this.address);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.indexes.size();
        }

        @Override
        public Tensor.Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.indexes);
            }
            ++this.count;
            this.indexes.next();
            this.reusedCell.value = IndexedTensor.this.get(this.indexes.toSourceValueIndex());
            return this.reusedCell;
        }
    }

    private final class SuperspaceIterator
    implements Iterator<SubspaceIterator> {
        private final Indexes superindexes;
        private final List<Integer> subdimensionIndexes;
        private final DimensionSizes iterateSizes;
        private int count = 0;

        private SuperspaceIterator(Set<String> superdimensionNames, DimensionSizes iterateSizes) {
            this.iterateSizes = iterateSizes;
            ArrayList<Integer> superdimensionIndexes = new ArrayList<Integer>(superdimensionNames.size());
            this.subdimensionIndexes = new ArrayList<Integer>(superdimensionNames.size());
            for (int i = IndexedTensor.this.type.dimensions().size() - 1; i >= 0; --i) {
                if (superdimensionNames.contains(IndexedTensor.this.type.dimensions().get(i).name())) {
                    superdimensionIndexes.add(i);
                    continue;
                }
                this.subdimensionIndexes.add(i);
            }
            this.superindexes = Indexes.of(IndexedTensor.this.dimensionSizes, iterateSizes, superdimensionIndexes);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.superindexes.size();
        }

        @Override
        public SubspaceIterator next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.superindexes);
            }
            ++this.count;
            this.superindexes.next();
            return new SubspaceIterator(this.subdimensionIndexes, this.superindexes.indexesCopy(), this.iterateSizes);
        }
    }

    private final class ValueIterator
    implements Iterator<Double> {
        private int count = 0;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IndexedTensor.this.values.length;
        }

        @Override
        public Double next() {
            try {
                return IndexedTensor.this.values[this.count++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("No element at position " + this.count);
            }
        }
    }

    private final class CellIterator
    implements Iterator<Tensor.Cell> {
        private int count = 0;
        private final Indexes indexes = Indexes.access$400(IndexedTensor.access$1400(IndexedTensor.this), IndexedTensor.access$1400(IndexedTensor.this), IndexedTensor.access$1500(IndexedTensor.this).length);
        private final LazyCell reusedCell = new LazyCell(this.indexes, Double.NaN);

        private CellIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < this.indexes.size();
        }

        @Override
        public Tensor.Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.indexes);
            }
            ++this.count;
            this.indexes.next();
            this.reusedCell.value = IndexedTensor.this.get(this.indexes.toSourceValueIndex());
            return this.reusedCell;
        }
    }

    private static class UnboundBuilder
    extends Builder {
        private List<Object> firstDimension = null;

        private UnboundBuilder(TensorType type) {
            super(type);
        }

        @Override
        public IndexedTensor build() {
            if (this.firstDimension == null) {
                throw new IllegalArgumentException("Tensor of type " + this.type() + " has no values");
            }
            if (this.type.dimensions().isEmpty()) {
                return new IndexedTensor(this.type, new DimensionSizes.Builder(this.type.dimensions().size()).build(), new double[]{(Double)this.firstDimension.get(0)});
            }
            DimensionSizes dimensionSizes = this.findDimensionSizes(this.firstDimension);
            double[] values = new double[dimensionSizes.totalSize()];
            this.fillValues(0, 0, this.firstDimension, dimensionSizes, values);
            return new IndexedTensor(this.type, dimensionSizes, values);
        }

        private DimensionSizes findDimensionSizes(List<Object> firstDimension) {
            ArrayList<Integer> dimensionSizeList = new ArrayList<Integer>(this.type.dimensions().size());
            this.findDimensionSizes(0, dimensionSizeList, firstDimension);
            DimensionSizes.Builder b = new DimensionSizes.Builder(this.type.dimensions().size());
            for (int i = 0; i < b.dimensions(); ++i) {
                if (i >= dimensionSizeList.size()) continue;
                b.set(i, (Integer)dimensionSizeList.get(i));
            }
            return b.build();
        }

        private void findDimensionSizes(int currentDimensionIndex, List<Integer> dimensionSizes, List<Object> currentDimension) {
            if (currentDimensionIndex == dimensionSizes.size()) {
                dimensionSizes.add(currentDimension.size());
            } else if (dimensionSizes.get(currentDimensionIndex).intValue() != currentDimension.size()) {
                throw new IllegalArgumentException("Missing values in dimension " + this.type.dimensions().get(currentDimensionIndex) + " in " + this.type);
            }
            for (Object value : currentDimension) {
                if (!(value instanceof List)) continue;
                this.findDimensionSizes(currentDimensionIndex + 1, dimensionSizes, (List)value);
            }
        }

        private void fillValues(int currentDimensionIndex, int offset, List<Object> currentDimension, DimensionSizes sizes, double[] values) {
            if (currentDimensionIndex < sizes.dimensions() - 1) {
                for (int i = 0; i < currentDimension.size(); ++i) {
                    this.fillValues(currentDimensionIndex + 1, offset + IndexedTensor.productOfDimensionsAfter(currentDimensionIndex, sizes) * i, (List)currentDimension.get(i), sizes, values);
                }
            } else {
                for (int i = 0; i < currentDimension.size(); ++i) {
                    values[offset + i] = this.nullAsZero((Double)currentDimension.get(i));
                }
            }
        }

        private double nullAsZero(Double value) {
            if (value == null) {
                return 0.0;
            }
            return value;
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type, this);
        }

        @Override
        public Builder cell(TensorAddress address, double value) {
            int[] indexes = new int[address.size()];
            for (int i = 0; i < address.size(); ++i) {
                indexes[i] = address.intLabel(i);
            }
            this.cell(value, indexes);
            return this;
        }

        @Override
        public Builder cell(double value, int ... indexes) {
            if (indexes.length != this.type.dimensions().size()) {
                throw new IllegalArgumentException("Wrong number of indexes (" + indexes.length + ") for " + this.type);
            }
            if (indexes.length == 0) {
                this.firstDimension = Collections.singletonList(value);
                return this;
            }
            if (this.firstDimension == null) {
                this.firstDimension = new ArrayList<Object>();
            }
            List currentValues = this.firstDimension;
            for (int dimensionIndex = 0; dimensionIndex < indexes.length; ++dimensionIndex) {
                this.ensureCapacity(indexes[dimensionIndex], currentValues);
                if (dimensionIndex == indexes.length - 1) {
                    currentValues.set(indexes[dimensionIndex], value);
                    continue;
                }
                if (currentValues.get(indexes[dimensionIndex]) == null) {
                    currentValues.set(indexes[dimensionIndex], new ArrayList());
                }
                currentValues = (List)currentValues.get(indexes[dimensionIndex]);
            }
            return this;
        }

        private void ensureCapacity(int index, List<Object> list) {
            while (list.size() <= index) {
                list.add(list.size(), null);
            }
        }
    }

    public static class BoundBuilder
    extends Builder {
        private DimensionSizes sizes;
        private double[] values;

        private BoundBuilder(TensorType type) {
            this(type, BoundBuilder.dimensionSizesOf(type));
        }

        static DimensionSizes dimensionSizesOf(TensorType type) {
            DimensionSizes.Builder b = new DimensionSizes.Builder(type.dimensions().size());
            for (int i = 0; i < type.dimensions().size(); ++i) {
                b.set(i, type.dimensions().get(i).size().get());
            }
            return b.build();
        }

        private BoundBuilder(TensorType type, DimensionSizes sizes) {
            super(type);
            if (sizes.dimensions() != type.dimensions().size()) {
                throw new IllegalArgumentException("Must have a dimension size entry for each dimension in " + type);
            }
            this.sizes = sizes;
            this.values = new double[sizes.totalSize()];
        }

        @Override
        public BoundBuilder cell(double value, int ... indexes) {
            this.values[IndexedTensor.toValueIndex((int[])indexes, (DimensionSizes)this.sizes)] = value;
            return this;
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type, this);
        }

        @Override
        public Builder cell(TensorAddress address, double value) {
            this.values[IndexedTensor.toValueIndex((TensorAddress)address, (DimensionSizes)this.sizes)] = value;
            return this;
        }

        @Override
        public IndexedTensor build() {
            IndexedTensor tensor = new IndexedTensor(this.type, this.sizes, this.values);
            this.sizes = null;
            this.values = null;
            return tensor;
        }

        @Override
        public Builder cell(Tensor.Cell cell, double value) {
            int directIndex = cell.getDirectIndex();
            if (directIndex >= 0) {
                this.values[directIndex] = value;
            } else {
                super.cell(cell, value);
            }
            return this;
        }

        public void cellByDirectIndex(int index, double value) {
            this.values[index] = value;
        }
    }

    public static abstract class Builder
    implements Tensor.Builder {
        final TensorType type;

        private Builder(TensorType type) {
            this.type = type;
        }

        public static Builder of(TensorType type) {
            if (type.dimensions().stream().allMatch(d -> d instanceof TensorType.IndexedBoundDimension)) {
                return new BoundBuilder(type);
            }
            return new UnboundBuilder(type);
        }

        public static Builder of(TensorType type, DimensionSizes sizes) {
            if (sizes.dimensions() != type.dimensions().size()) {
                throw new IllegalArgumentException(sizes.dimensions() + " is the wrong number of dimensions for " + type);
            }
            for (int i = 0; i < sizes.dimensions(); ++i) {
                Optional<Integer> size = type.dimensions().get(i).size();
                if (!size.isPresent() || size.get() >= sizes.size(i)) continue;
                throw new IllegalArgumentException("Size of dimension " + type.dimensions().get(i).name() + " is " + sizes.size(i) + " but cannot be larger than " + size.get() + " in " + type);
            }
            return new BoundBuilder(type, sizes);
        }

        @Override
        public abstract Builder cell(double var1, int ... var3);

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public abstract IndexedTensor build();
    }
}

