/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.path;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Beta
public final class Path {
    private final String delimiter;
    private final List<String> elements = new ArrayList<String>();

    private Path(String delimiter) {
        this(new ArrayList<String>(), delimiter);
    }

    private Path(Path rhs) {
        this(rhs.elements, rhs.delimiter);
    }

    private Path(List<String> elements, String delimiter) {
        this.elements.addAll(elements);
        this.delimiter = delimiter;
    }

    public boolean isChildOf(Path parent) {
        return this.toString().startsWith(parent.toString()) && this.elements.size() - 1 == parent.elements.size();
    }

    private void addElementsFromString(String path) {
        String[] pathElements = path.split(this.delimiter);
        if (pathElements != null) {
            for (String elem : pathElements) {
                if ("".equals(elem)) continue;
                this.elements.add(elem);
            }
        }
    }

    public Path append(String name) {
        Path path = new Path(this);
        path.addElementsFromString(name);
        return path;
    }

    public Path append(Path path) {
        Path newPath = new Path(this);
        newPath.elements.addAll(path.elements);
        return newPath;
    }

    public String getName() {
        if (this.elements.isEmpty()) {
            return "";
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public String getRelative() {
        if (this.elements.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.elements.get(0));
        for (int i = 1; i < this.elements.size(); ++i) {
            sb.append(this.delimiter);
            sb.append(this.elements.get(i));
        }
        return sb.toString();
    }

    public Path getParentPath() {
        ArrayList<String> parentElements = new ArrayList<String>();
        if (this.elements.size() > 1) {
            for (int i = 0; i < this.elements.size() - 1; ++i) {
                parentElements.add(this.elements.get(i));
            }
        }
        return new Path(parentElements, this.delimiter);
    }

    public String getAbsolute() {
        return this.delimiter + this.getRelative();
    }

    public boolean isRoot() {
        return this.elements.isEmpty();
    }

    public Iterator<String> iterator() {
        return this.elements.iterator();
    }

    public String toString() {
        return this.getRelative();
    }

    public static Path fromString(String path) {
        return Path.fromString(path, "/");
    }

    public static Path fromString(String path, String delimiter) {
        Path pathObj = new Path(delimiter);
        pathObj.addElementsFromString(path);
        return pathObj;
    }

    public static Path createRoot() {
        return Path.createRoot("/");
    }

    public static Path createRoot(String delimiter) {
        return new Path(delimiter);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Path) {
            return this.getRelative().equals(((Path)other).getRelative());
        }
        return false;
    }
}

