/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cache;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class SizeCalculator {
    private final IdentityHashMap<Class<?>, Integer> primitiveSizes = new IdentityHashMap<Class<?>, Integer>(){
        {
            this.put(Boolean.TYPE, 1);
            this.put(Byte.TYPE, 1);
            this.put(Character.TYPE, 2);
            this.put(Short.TYPE, 2);
            this.put(Integer.TYPE, 4);
            this.put(Float.TYPE, 4);
            this.put(Double.TYPE, 8);
            this.put(Long.TYPE, 8);
        }
    };

    private int getPointerSize() {
        return 4;
    }

    private int getClassSize() {
        return 8;
    }

    private int getArraySize() {
        return 16;
    }

    private long sizeOfArray(Object a, ObjectSet visitedObjects) {
        long sum = this.getArraySize();
        int length = Array.getLength(a);
        if (length == 0) {
            return sum;
        }
        Class<?> elementClass = a.getClass().getComponentType();
        if (elementClass.isPrimitive()) {
            return sum += (long)(length * this.primitiveSizes.get(elementClass));
        }
        for (int i = 0; i < length; ++i) {
            Object val = Array.get(a, i);
            sum += (long)this.getPointerSize();
            sum += this.sizeOfObject(val, visitedObjects);
        }
        return sum;
    }

    private long getSumOfFields(Class<?> clas, Object obj, ObjectSet visitedObjects) {
        Field[] fields;
        long sum = 0L;
        for (Field field : fields = clas.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (field.getType().isPrimitive()) {
                sum += (long)this.primitiveSizes.get(field.getType()).intValue();
                continue;
            }
            sum += (long)this.getPointerSize();
            field.setAccessible(true);
            try {
                sum += this.sizeOfObject(field.get(obj), visitedObjects);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        return sum;
    }

    private boolean isIntern(Object obj) {
        return obj instanceof String && obj == ((String)obj).intern();
    }

    private long sizeOfNonArray(Class<?> clas, Object obj, ObjectSet visitedObjects) {
        if (this.isIntern(obj)) {
            return 0L;
        }
        long sum = this.getClassSize();
        while (clas != null) {
            sum += this.getSumOfFields(clas, obj, visitedObjects);
            clas = clas.getSuperclass();
        }
        return sum;
    }

    private long sizeOfObject(Object obj, ObjectSet visitedObjects) {
        if (obj == null) {
            return 0L;
        }
        if (visitedObjects.had(obj)) {
            return 0L;
        }
        Class<?> clas = obj.getClass();
        if (clas.isArray()) {
            return this.sizeOfArray(obj, visitedObjects);
        }
        return this.sizeOfNonArray(clas, obj, visitedObjects);
    }

    public long sizeOf(Object value) {
        ObjectSet visitedObjects = new ObjectSet();
        return this.sizeOfObject(value, visitedObjects);
    }

    public long sizeOf(Object value1, Object value2) {
        ObjectSet visitedObjects = new ObjectSet();
        return this.sizeOfObject(value1, visitedObjects) + this.sizeOfObject(value2, visitedObjects);
    }

    public long sizeOf(List<?> objects) {
        ObjectSet visitedObjects = new ObjectSet();
        long sum = 0L;
        for (Object o : objects) {
            sum += this.sizeOfObject(o, visitedObjects);
        }
        return sum;
    }

    private static class ObjectSet {
        private final Map<Object, Object> map = new IdentityHashMap<Object, Object>();

        private ObjectSet() {
        }

        public boolean had(Object obj) {
            if (this.map.containsKey(obj)) {
                return true;
            }
            this.map.put(obj, null);
            return false;
        }
    }
}

