/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool;

import com.yahoo.vespa.security.tool.CliOptions;
import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import com.yahoo.vespa.security.tool.ToolInvocation;
import com.yahoo.vespa.security.tool.crypto.ConvertBaseTool;
import com.yahoo.vespa.security.tool.crypto.DecryptTool;
import com.yahoo.vespa.security.tool.crypto.EncryptTool;
import com.yahoo.vespa.security.tool.crypto.KeygenTool;
import com.yahoo.vespa.security.tool.crypto.ResealTool;
import com.yahoo.vespa.security.tool.crypto.TokenInfoTool;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private final InputStream stdIn;
    private final PrintStream stdOut;
    private final PrintStream stdError;
    private static final List<Tool> TOOLS = List.of(new KeygenTool(), new EncryptTool(), new DecryptTool(), new TokenInfoTool(), new ConvertBaseTool(), new ResealTool());

    Main(InputStream stdIn, PrintStream stdOut, PrintStream stdError) {
        this.stdIn = stdIn;
        this.stdOut = stdOut;
        this.stdError = stdError;
    }

    public static void main(String[] args) {
        Main program = new Main(System.in, System.out, System.err);
        int returnCode = program.execute(args, System.getenv());
        System.exit(returnCode);
    }

    private static Optional<Tool> toolFromCliArgs(String[] args) {
        if (args.length == 0) {
            return Optional.empty();
        }
        String toolName = args[0];
        return TOOLS.stream().filter(t -> t.name().equals(toolName)).findFirst();
    }

    private static String[] withToolNameArgRemoved(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Argument array did not contain a tool name");
        }
        String[] truncatedArgs = new String[args.length - 1];
        System.arraycopy(args, 1, truncatedArgs, 0, truncatedArgs.length);
        return truncatedArgs;
    }

    private static CommandLine parseCliArguments(String[] cliArgs, Options options) throws ParseException {
        DefaultParser parser = new DefaultParser();
        return parser.parse(options, cliArgs);
    }

    public int execute(String[] args, Map<String, String> envVars) {
        boolean debugMode = envVars.containsKey("VESPA_DEBUG");
        try {
            Optional<Tool> maybeTool = Main.toolFromCliArgs(args);
            if (maybeTool.isEmpty()) {
                CliOptions.printTopLevelHelp(this.stdOut, TOOLS);
                return 0;
            }
            Tool tool = maybeTool.get();
            ToolDescription toolDesc = tool.description();
            Options cliOpts = CliOptions.withHelpOption(toolDesc.cliOptions());
            String[] truncatedArgs = Main.withToolNameArgRemoved(args);
            CommandLine cmdLine = Main.parseCliArguments(truncatedArgs, cliOpts);
            if (cmdLine.hasOption("help")) {
                CliOptions.printToolSpecificHelp(this.stdOut, tool.name(), toolDesc, cliOpts);
                return 0;
            }
            ToolInvocation invocation = new ToolInvocation(cmdLine, envVars, this.stdIn, this.stdOut, this.stdError, debugMode);
            return tool.invoke(invocation);
        }
        catch (ParseException e) {
            return this.handleException("Failed to parse command line arguments: " + e.getMessage(), (Exception)((Object)e), debugMode);
        }
        catch (IllegalArgumentException e) {
            return this.handleException("Invalid command line arguments: " + e.getMessage(), e, debugMode);
        }
        catch (Exception e) {
            return this.handleException("Got unhandled exception: " + e.getMessage(), e, debugMode);
        }
    }

    private int handleException(String message, Exception exception, boolean debugMode) {
        this.stdError.println(message);
        if (debugMode) {
            exception.printStackTrace(this.stdError);
        }
        return 1;
    }
}

