/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

public class CipherUtils {
    public static void streamEncipherFileContents(Path fromPath, Path toPath, Cipher cipher) throws IOException {
        if (fromPath.equals(toPath)) {
            throw new IllegalArgumentException("Can't use same file as both input and output for enciphering");
        }
        try (InputStream inStream = Files.newInputStream(fromPath, new OpenOption[0]);
             OutputStream outStream = Files.newOutputStream(toPath, new OpenOption[0]);
             CipherOutputStream cipherStream = new CipherOutputStream(outStream, cipher);){
            inStream.transferTo(cipherStream);
            cipherStream.flush();
        }
    }
}

