/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespaget;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.vespaget.ClientParameters;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineOptions {
    public static final String HELP_OPTION = "help";
    public static final String PRINTIDS_OPTION = "printids";
    public static final String FIELDSET_OPTION = "fieldset";
    public static final String CLUSTER_OPTION = "cluster";
    public static final String ROUTE_OPTION = "route";
    public static final String CONFIGID_OPTION = "configid";
    public static final String SHOWDOCSIZE_OPTION = "showdocsize";
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String NORETRY_OPTION = "noretry";
    public static final String TRACE_OPTION = "trace";
    public static final String PRIORITY_OPTION = "priority";
    public static final String JSONOUTPUT_OPTION = "jsonoutput";
    public static final String XMLOUTPUT_OPTION = "xmloutput";
    public static final String SHORTTENSORS_OPTION = "shorttensors";
    public static final String DIRECTTENSORS_OPTION = "directtensors";
    public static final String REPLICA_OPTION = "replica-override";
    private final Options options = CommandLineOptions.createOptions();
    private final InputStream stdIn;

    public CommandLineOptions(InputStream stdIn) {
        this.stdIn = stdIn;
    }

    public CommandLineOptions() {
        this(System.in);
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").hasArg(false).desc("Show this syntax page.").longOpt(HELP_OPTION).build());
        options.addOption(Option.builder((String)"i").hasArg(false).desc("Show only identifiers of retrieved documents.").longOpt(PRINTIDS_OPTION).build());
        options.addOption(Option.builder((String)"f").hasArg(true).desc("Retrieve the specified fields only (see https://docs.vespa.ai/en/schemas/documents.html#fieldsets) (default '[document]')").longOpt(FIELDSET_OPTION).argName(FIELDSET_OPTION).build());
        options.addOption(Option.builder((String)"u").hasArg(true).desc("Send request to the given content cluster.").longOpt(CLUSTER_OPTION).argName(CLUSTER_OPTION).build());
        options.addOption(Option.builder((String)"r").hasArg(true).desc("Send request to the given messagebus route.").longOpt(ROUTE_OPTION).argName(ROUTE_OPTION).build());
        options.addOption(Option.builder((String)"c").hasArg(true).desc("Use the specified config id for messagebus configuration.").longOpt(CONFIGID_OPTION).argName(CONFIGID_OPTION).build());
        options.addOption(Option.builder((String)"s").hasArg(false).desc("Show binary size of document.").longOpt(SHOWDOCSIZE_OPTION).build());
        options.addOption(Option.builder((String)"t").hasArg(true).desc("Set timeout for the request in seconds (default 0).").longOpt(TIMEOUT_OPTION).argName(TIMEOUT_OPTION).type(Number.class).build());
        options.addOption(Option.builder((String)"n").hasArg(false).desc("Do not retry operation on transient errors, as is default.").longOpt(NORETRY_OPTION).build());
        options.addOption(Option.builder((String)"a").hasArg(true).desc("Trace level to use (default 0).").longOpt(TRACE_OPTION).argName(TRACE_OPTION).type(Number.class).build());
        options.addOption(Option.builder((String)"p").hasArg(true).desc("Priority (default 6).").longOpt(PRIORITY_OPTION).argName(PRIORITY_OPTION).build());
        options.addOption(Option.builder((String)"j").hasArg(false).desc("JSON output (default format)").longOpt(JSONOUTPUT_OPTION).build());
        options.addOption(Option.builder((String)"x").hasArg(false).desc("XML output").longOpt(XMLOUTPUT_OPTION).build());
        options.addOption(Option.builder().longOpt(SHORTTENSORS_OPTION).desc("Output JSON tensors in short form. Will be the default on Vespa 9").hasArg(false).build());
        options.addOption(Option.builder().hasArg(true).desc("Specify from which replica node to get the document").longOpt(REPLICA_OPTION).argName("nodeId").type(Integer.class).build());
        return options;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("vespa-get <options> [documentid...]", "Fetch a document from a Vespa Content cluster.", this.options, "If one or more document identifier are specified, these documents will be retrieved. Otherwise, document identifiers (separated with line break) will be read from standard in.\n", false);
    }

    public ClientParameters parseCommandLineArguments(String[] args) throws IllegalArgumentException {
        try {
            DefaultParser clp = new DefaultParser();
            CommandLine cl = clp.parse(this.options, args);
            boolean printIdsOnly = cl.hasOption(PRINTIDS_OPTION);
            String fieldSet = cl.getOptionValue(FIELDSET_OPTION, "");
            String cluster = cl.getOptionValue(CLUSTER_OPTION, "");
            String route = cl.getOptionValue(ROUTE_OPTION, "");
            String configId = cl.getOptionValue(CONFIGID_OPTION, "");
            boolean help = cl.hasOption(HELP_OPTION);
            boolean noRetry = cl.hasOption(NORETRY_OPTION);
            boolean showDocSize = cl.hasOption(SHOWDOCSIZE_OPTION);
            boolean jsonOutput = cl.hasOption(JSONOUTPUT_OPTION);
            boolean xmlOutput = cl.hasOption(XMLOUTPUT_OPTION);
            boolean shortTensors = cl.hasOption(SHORTTENSORS_OPTION);
            boolean directTensors = cl.hasOption(DIRECTTENSORS_OPTION);
            int trace = CommandLineOptions.getTrace(cl);
            Integer replica = CommandLineOptions.getReplica(cl);
            DocumentProtocol.Priority priority = CommandLineOptions.getPriority(cl);
            double timeout = CommandLineOptions.getTimeout(cl);
            Iterator<String> documentIds = this.getDocumentIds(cl);
            if (jsonOutput && xmlOutput) {
                throw new IllegalArgumentException("Cannot combine both xml and json output");
            }
            if (printIdsOnly && !fieldSet.isEmpty()) {
                throw new IllegalArgumentException("Field set option can not be used in combination with print ids option.");
            }
            if (printIdsOnly) {
                fieldSet = "[id]";
            } else if (fieldSet.isEmpty()) {
                fieldSet = "[document]";
            }
            if (!cluster.isEmpty() && !route.isEmpty()) {
                throw new IllegalArgumentException("Cluster and route options are mutually exclusive.");
            }
            if (route.isEmpty() && cluster.isEmpty()) {
                route = "default-get";
            }
            if (trace < 0 || trace > 9) {
                throw new IllegalArgumentException("Invalid tracelevel: " + trace);
            }
            if (configId.isEmpty()) {
                configId = "client";
            }
            ClientParameters.Builder paramsBuilder = new ClientParameters.Builder();
            return paramsBuilder.setDocumentIds(documentIds).setConfigId(configId).setFieldSet(fieldSet).setHelp(help).setPrintIdsOnly(printIdsOnly).setNoRetry(noRetry).setCluster(cluster).setRoute(route).setShowDocSize(showDocSize).setTraceLevel(trace).setPriority(priority).setTimeout(timeout).setJsonOutput(!xmlOutput).setTensorShortForm(shortTensors).setTensorDirectValues(directTensors).setDebugReplicaNodeId(replica).build();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    private Iterator<String> getDocumentIds(CommandLine cl) {
        List<String> documentIds = List.of(cl.getArgs());
        if (documentIds.isEmpty() || documentIds.size() == 1 && documentIds.get(0).isEmpty()) {
            return new Scanner(this.stdIn);
        }
        return documentIds.iterator();
    }

    private static double getTimeout(CommandLine cl) throws ParseException {
        Number timeoutObj = (Number)cl.getParsedOptionValue(TIMEOUT_OPTION);
        return timeoutObj != null ? timeoutObj.doubleValue() : 0.0;
    }

    private static int getTrace(CommandLine cl) throws ParseException {
        Number traceObj = (Number)cl.getParsedOptionValue(TRACE_OPTION);
        return traceObj != null ? traceObj.intValue() : 0;
    }

    private static Integer getReplica(CommandLine cl) throws ParseException {
        Integer node_id = (Integer)cl.getParsedOptionValue(REPLICA_OPTION);
        if (node_id != null && (node_id < 0 || node_id >= 65535)) {
            throw new IllegalArgumentException("Invalid replica node ID: " + node_id.toString() + ". Valid node ID must be between 0 and 65534 (inclusive)");
        }
        return node_id;
    }

    private static DocumentProtocol.Priority getPriority(CommandLine cl) throws ParseException {
        String priority = cl.getOptionValue(PRIORITY_OPTION, "NORMAL_2");
        return CommandLineOptions.parsePriority(priority);
    }

    private static DocumentProtocol.Priority parsePriority(String name) {
        try {
            return DocumentProtocol.Priority.valueOf((String)name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                int n = Integer.parseInt(name);
                for (DocumentProtocol.Priority priority : DocumentProtocol.Priority.values()) {
                    if (priority.getValue() != n) continue;
                    return priority;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new IllegalArgumentException("Invalid priority: " + name);
        }
    }
}

