/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.export;

import ai.vespa.vespasignificance.export.PathSelector;
import ai.vespa.vespasignificance.export.SelectionException;
import com.yahoo.vespa.defaults.Defaults;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class IndexLocator {
    private final Path vespaHome;
    private static final Pattern TRAILING_NUM = Pattern.compile(".*\\.(\\d+)$");

    public IndexLocator() {
        this(Path.of(Defaults.getDefaults().vespaHome(), new String[0]));
    }

    IndexLocator(Path vespaHome) {
        this.vespaHome = Objects.requireNonNull(vespaHome);
    }

    Path locateIndexDir(@Nullable String clusterName, @Nullable String schemaName, @Nullable String nodeIndex) throws NoSuchFileException {
        Path searchRoot = this.vespaHome.resolve(Path.of("var", "db", "vespa", "search"));
        List<Path> clusterDirs = IndexLocator.listDirs(searchRoot, p -> p.getFileName().toString().startsWith("cluster"));
        PathSelector.Result<Path> clusterRes = PathSelector.selectOne(clusterDirs, clusterName, "cluster", searchRoot, p -> {
            String name = p.getFileName().toString();
            return name.startsWith("cluster.") ? name.substring("cluster.".length()) : name;
        }, Path::toString);
        Path clusterDir = IndexLocator.chooseOrThrow(clusterRes, "cluster");
        List<Path> nodeDirs = IndexLocator.listDirs(clusterDir, p -> Files.isDirectory(p, new LinkOption[0]) && p.getFileName().toString().matches("n\\d+"));
        PathSelector.Result<Path> nodeRes = PathSelector.selectOne(nodeDirs, nodeIndex, "node-index", clusterDir, p -> p.getFileName().toString().substring(1), Path::toString);
        Path nodeDir = IndexLocator.chooseOrThrow(nodeRes, "node-index");
        Path documentsDir = nodeDir.resolve("documents");
        if (!Files.isDirectory(documentsDir, new LinkOption[0])) {
            throw new NoSuchFileException("Documents directory does not exist: " + String.valueOf(documentsDir));
        }
        List<Path> schemaDirs = IndexLocator.listDirs(documentsDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        PathSelector.Result<Path> schemaRes = PathSelector.selectOne(schemaDirs, schemaName, "schema", documentsDir, p -> p.getFileName().toString(), Path::toString);
        Path schemaDir = IndexLocator.chooseOrThrow(schemaRes, "schema");
        Path indexDir = schemaDir.resolve("0.ready").resolve("index");
        if (!Files.exists(indexDir, new LinkOption[0])) {
            throw new NoSuchFileException("Index directory does not exist: " + String.valueOf(indexDir));
        }
        List<Path> candidates = IndexLocator.listDirs(indexDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        if (candidates.isEmpty()) {
            throw new NoSuchFileException("There are no flushed indexes on disk in: " + String.valueOf(indexDir));
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        System.err.println("Found " + candidates.size() + " index candidates. Output might be unstable.");
        Comparator<Path> bySeqDesc = Comparator.comparingInt(IndexLocator::seq).reversed().thenComparing(p -> p.getFileName().toString());
        Optional<Path> latestFusion = candidates.stream().map(Path::getFileName).map(Path::toString).map(indexDir::resolve).filter(p -> p.getFileName().toString().contains("fusion")).max(bySeqDesc);
        if (latestFusion.isPresent()) {
            return latestFusion.get();
        }
        Optional<Path> latestFlush = candidates.stream().map(Path::getFileName).map(Path::toString).map(indexDir::resolve).filter(p -> p.getFileName().toString().contains("flush")).max(bySeqDesc);
        if (latestFlush.isPresent()) {
            return latestFlush.get();
        }
        throw new NoSuchFileException("Found no fusion/flush directories ending with .<number> under: " + String.valueOf(indexDir));
    }

    private static <T> T chooseOrThrow(PathSelector.Result<T> res, String kind) {
        if (res.outcome() == PathSelector.Outcome.CHOSEN) {
            return res.value();
        }
        throw new SelectionException(res.outcome(), kind, res.message(), res.options());
    }

    private static List<Path> listDirs(Path root, Predicate<Path> filter) throws NoSuchFileException {
        List<Path> list;
        block9: {
            if (!Files.isDirectory(root, new LinkOption[0])) {
                throw new NoSuchFileException("Not a directory: " + String.valueOf(root));
            }
            Stream<Path> s = Files.list(root);
            try {
                list = s.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(filter).sorted().toList();
                if (s == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to list: " + String.valueOf(root), e);
                }
            }
            s.close();
        }
        return list;
    }

    private static int seq(Path p) {
        String name = p.getFileName().toString();
        Matcher m = TRAILING_NUM.matcher(name);
        return m.matches() ? Integer.parseInt(m.group(1)) : -1;
    }
}

