/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.generate;

import ai.vespa.vespasignificance.common.VespaSignificanceTsvReader;
import ai.vespa.vespasignificance.generate.FormatStrategy;
import io.airlift.compress.zstd.ZstdInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.TreeMap;

public final class VstsvFormatStrategy
implements FormatStrategy {
    private final Path input;
    private final String languageKey;

    public VstsvFormatStrategy(Path input) {
        this.input = input;
        this.languageKey = "un";
    }

    @Override
    public FormatStrategy.Result build() throws IOException {
        try (Reader r = VstsvFormatStrategy.openReader(this.input);){
            FormatStrategy.Result result;
            try (VespaSignificanceTsvReader vstsv = new VespaSignificanceTsvReader(r);){
                long docCount = vstsv.header().documentCount();
                TreeMap<String, Long> df = new TreeMap<String, Long>();
                while (vstsv.next()) {
                    df.merge(vstsv.term(), vstsv.df(), Long::sum);
                }
                result = new FormatStrategy.Result(df, docCount);
            }
            return result;
        }
    }

    @Override
    public String languageKey() {
        return this.languageKey;
    }

    private static Reader openReader(Path p) throws IOException {
        InputStream in = Files.newInputStream(p, new OpenOption[0]);
        BufferedInputStream bin = new BufferedInputStream(in, 65536);
        if (p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".zst")) {
            return new InputStreamReader((InputStream)new ZstdInputStream((InputStream)bin), StandardCharsets.UTF_8);
        }
        return new InputStreamReader((InputStream)bin, StandardCharsets.UTF_8);
    }
}

