/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.export;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;

final class PathSelector {
    PathSelector() {
    }

    static <T> Result<T> selectOne(List<T> items, @Nullable String preferredName, String kind, Path container, Function<T, String> displayName, Function<T, String> displayPath, BiPredicate<String, String> nameMatcher) {
        String msg;
        if (items.isEmpty()) {
            return Result.notFound("No " + kind + " directory found in: " + String.valueOf(container), List.of());
        }
        if (items.size() == 1 && preferredName == null) {
            return Result.chosen(items.get(0));
        }
        ArrayList<Map.Entry<T, Row>> candidates = new ArrayList<Map.Entry<T, Row>>(items.size());
        for (T t : items) {
            String name = displayName.apply(t);
            String path = displayPath.apply(t);
            candidates.add(Map.entry(t, new Row(name, path)));
        }
        candidates.sort(Comparator.comparing(e -> ((Row)e.getValue()).name().toLowerCase(Locale.ROOT)));
        if (preferredName != null) {
            for (Map.Entry entry : candidates) {
                if (!nameMatcher.test(((Row)entry.getValue()).name(), preferredName)) continue;
                return Result.chosen(entry.getKey());
            }
            msg = PathSelector.capitalize(kind) + " '" + preferredName + "' not found under: " + String.valueOf(container) + System.lineSeparator() + "Use `--" + kind + " <name>` to select one of the options below.";
            return Result.notFound(msg, PathSelector.rows(candidates));
        }
        msg = "Multiple " + kind + " directories found in: " + String.valueOf(container) + System.lineSeparator() + "Use `--" + kind + " <name>` to select one of the options below.";
        return Result.ambiguous(msg, PathSelector.rows(candidates));
    }

    static <T> Result<T> selectOne(List<T> items, @Nullable String preferredName, String kind, Path container, Function<T, String> displayName, Function<T, String> displayPath) {
        return PathSelector.selectOne(items, preferredName, kind, container, displayName, displayPath, String::equals);
    }

    private static <T> List<Row> rows(List<Map.Entry<T, Row>> entries) {
        return entries.stream().map(Map.Entry::getValue).toList();
    }

    private static String capitalize(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
    }

    record Result<T>(Outcome outcome, @Nullable T value, String message, List<Row> options) {
        static <T> Result<T> chosen(T value) {
            return new Result<T>(Outcome.CHOSEN, Objects.requireNonNull(value), "", List.of());
        }

        static <T> Result<T> notFound(String msg, List<Row> options) {
            return new Result<Object>(Outcome.NOT_FOUND, null, msg, options);
        }

        static <T> Result<T> ambiguous(String msg, List<Row> options) {
            return new Result<Object>(Outcome.AMBIGUOUS, null, msg, options);
        }
    }

    record Row(String name, String path) {
    }

    static enum Outcome {
        CHOSEN,
        NOT_FOUND,
        AMBIGUOUS;

    }
}

