/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.export;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class VespaFileHeaderInspectClient {
    private final String executable;
    private final ProcessStarter processStarter;
    private final Duration waitForExit;

    public VespaFileHeaderInspectClient() {
        this("vespa-fileheader-inspect");
    }

    public VespaFileHeaderInspectClient(String executable) {
        this(executable, cmd -> new ProcessBuilder(cmd).redirectErrorStream(true).start(), Duration.ofSeconds(5L));
    }

    public VespaFileHeaderInspectClient(String executable, ProcessStarter processStarter, Duration waitForExit) {
        this.executable = Objects.requireNonNull(executable, "executable");
        if (executable.isBlank()) {
            throw new IllegalArgumentException("executable is blank");
        }
        this.processStarter = Objects.requireNonNull(processStarter, "processStarter");
        this.waitForExit = Objects.requireNonNull(waitForExit, "waitForExit");
    }

    public long readDocIdLimit(Path indexDir) throws IOException {
        Objects.requireNonNull(indexDir, "indexDir");
        Path selector = indexDir.resolve("selector.dat");
        if (!Files.isRegularFile(selector, new LinkOption[0])) {
            throw new IOException("Missing selector.dat: " + String.valueOf(selector));
        }
        List<String> cmd = List.of(this.executable, selector.toString());
        Process p = this.processStarter.start(cmd);
        try {
            long l;
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));
            try {
                Long value = VespaFileHeaderInspectClient.parseDocIdLimit(br);
                this.waitAndCheckExit(p);
                if (value == null) {
                    throw new IOException("docIdLimit not found in vespa-fileheader-inspect output for " + String.valueOf(selector));
                }
                l = value;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (UncheckedIOException uioe) {
                    throw uioe.getCause();
                }
            }
            br.close();
            return l;
        }
        finally {
            p.getInputStream().close();
        }
    }

    static Long parseDocIdLimit(Reader reader) {
        Long l;
        block9: {
            BufferedReader b;
            Objects.requireNonNull(reader, "reader");
            BufferedReader br = reader instanceof BufferedReader ? (b = (BufferedReader)reader) : new BufferedReader(reader);
            try {
                String line;
                Long spaced = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) != '|') continue;
                    boolean TAG_INDEX = true;
                    int VALUE_INDEX = 3;
                    String[] parts = line.split("\\|");
                    if (parts.length < 4) continue;
                    String tag = parts[1].trim();
                    String value = parts[3].trim();
                    if (tag.isEmpty() || value.isEmpty() || !tag.equals("Doc id limit")) continue;
                    spaced = Long.parseLong(value);
                }
                l = spaced;
                if (br == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            br.close();
        }
        return l;
    }

    private void waitAndCheckExit(Process p) throws IOException {
        try {
            int exit;
            if (!p.waitFor(this.waitForExit.toSeconds(), TimeUnit.SECONDS)) {
                p.destroyForcibly();
                p.waitFor(3L, TimeUnit.SECONDS);
            }
            if ((exit = p.exitValue()) != 0) {
                throw new IOException(this.executable + " exited with code " + exit);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted waiting for " + this.executable + " exit", ie);
        }
    }

    @FunctionalInterface
    public static interface ProcessStarter {
        public Process start(List<String> var1) throws IOException;
    }
}

