/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.export;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class TablePrinter {
    TablePrinter() {
    }

    static void printTable(String heading, List<String> headers, List<List<String>> rows) {
        TablePrinter.printTable(System.out, heading, headers, rows);
    }

    static void printTable(PrintStream out, String heading, List<String> headers, List<List<String>> rows) {
        int c;
        int cols;
        if (headers == null) {
            headers = Collections.emptyList();
        }
        if (rows == null) {
            rows = Collections.emptyList();
        }
        if ((cols = headers.size()) == 0) {
            if (heading != null && !heading.isEmpty()) {
                out.println(heading);
            }
            return;
        }
        ArrayList normalized = new ArrayList(rows.size());
        for (List<String> row : rows) {
            ArrayList<String> arrayList = new ArrayList<String>(cols);
            for (c = 0; c < cols; ++c) {
                String string = row != null && c < row.size() ? row.get(c) : "";
                arrayList.add(string == null ? "" : string);
            }
            normalized.add(arrayList);
        }
        int[] widths = new int[cols];
        for (int c2 = 0; c2 < cols; ++c2) {
            widths[c2] = TablePrinter.len(TablePrinter.safe(headers.get(c2)));
        }
        for (List list : normalized) {
            for (c = 0; c < cols; ++c) {
                widths[c] = Math.max(widths[c], TablePrinter.len(TablePrinter.safe((String)list.get(c))));
            }
        }
        String sep = TablePrinter.buildSeparator(widths);
        int n = sep.length();
        if (heading != null && !heading.isEmpty()) {
            out.println(TablePrinter.center(heading, n));
        }
        out.println(sep);
        out.println(TablePrinter.buildRow(headers, widths));
        out.println(sep);
        for (List list : normalized) {
            out.println(TablePrinter.buildRow(list, widths));
        }
        out.println(sep);
    }

    private static String buildSeparator(int[] widths) {
        StringBuilder sb = new StringBuilder();
        sb.append('+');
        for (int w : widths) {
            sb.append(TablePrinter.repeat('-', w + 2)).append('+');
        }
        return sb.toString();
    }

    private static String buildRow(List<String> cells, int[] widths) {
        StringBuilder sb = new StringBuilder();
        sb.append('|');
        for (int c = 0; c < widths.length; ++c) {
            String v = c < cells.size() ? TablePrinter.safe(cells.get(c)) : "";
            sb.append(' ').append(TablePrinter.padRight(v, widths[c])).append(' ').append('|');
        }
        return sb.toString();
    }

    private static String padRight(String s, int width) {
        int pad = width - TablePrinter.len(s);
        if (pad <= 0) {
            return s;
        }
        return s + TablePrinter.repeat(' ', pad);
    }

    private static String center(String s, int width) {
        int w = Math.max(0, width);
        if (TablePrinter.len(s) >= w) {
            return s;
        }
        int totalPad = w - TablePrinter.len(s);
        int left = totalPad / 2;
        int right = totalPad - left;
        return TablePrinter.repeat(' ', left) + s + TablePrinter.repeat(' ', right);
    }

    private static String repeat(char ch, int count) {
        if (count <= 0) {
            return "";
        }
        char[] arr = new char[count];
        Arrays.fill(arr, ch);
        return new String(arr);
    }

    private static int len(String s) {
        return s == null ? 0 : s.length();
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }
}

