/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespasignificance;

import ai.vespa.vespasignificance.export.ExportClientParameters;
import com.yahoo.vespasignificance.ClientParameters;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CommandLineOptions {
    public static final String HELP_OPTION = "help";
    public static final String INPUT_OPTION = "in";
    public static final String OUTPUT_OPTION = "output";
    public static final String FIELD_OPTION = "field";
    public static final String LANGUAGE_OPTION = "language";
    public static final String ZST_COMPRESSION = "zst-compression";
    public static final String INDEX_DIR = "index-dir";
    public static final String CLUSTER_OPTION = "cluster";
    public static final String SCHEMA_NAME = "schema";
    public static final String NODE_INDEX_OPTION = "node-index";

    static Options createGlobalOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show available commands.").build());
        return options;
    }

    static Map<String, String> registeredCommands() {
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        commands.put("generate", "Generate a significance model from a JSONL feed file.");
        commands.put("export", "Export terms and document frequency from a flushed index to TSV.");
        return commands;
    }

    static void printGlobalHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(100);
        fmt.setLeftPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        Comparator byName = String.CASE_INSENSITIVE_ORDER;
        StringBuilder header = new StringBuilder("Commands:\n");
        CommandLineOptions.registeredCommands().entrySet().stream().sorted(Map.Entry.comparingByKey(byName)).forEach(e -> header.append(String.format("  %-12s %s%n", e.getKey(), e.getValue())));
        header.append("\nOptions:");
        fmt.printHelp("vespa-significance <command> [options]", header.toString(), CommandLineOptions.createGlobalOptions(), "", false);
    }

    static Options createGenerateOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show this help and exit.").build());
        options.addOption(Option.builder((String)"i").longOpt(INPUT_OPTION).required().hasArg().argName("file.jsonl").desc("Input JSON Lines file. One Vespa document per line.").build());
        options.addOption(Option.builder((String)"o").longOpt(OUTPUT_OPTION).required().hasArg().argName("model.json[.zst]").desc("Output model file.").build());
        options.addOption(Option.builder((String)"f").longOpt(FIELD_OPTION).required().hasArg().argName("fieldName").desc("Document field to analyze.").build());
        options.addOption(Option.builder((String)"l").longOpt(LANGUAGE_OPTION).required().hasArg().argName("tag[,tag...]").desc("ISO language tag(s), comma-separated (e.g., 'en', 'no', or 'en,no').").build());
        options.addOption(Option.builder((String)"zst").longOpt(ZST_COMPRESSION).hasArg().argName("true|false").desc("Use Zstandard compression (default: false). If true, --out must end with .zst.").build());
        return options;
    }

    public static void printGenerateHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(100);
        fmt.setLeftPadding(2);
        fmt.setDescPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        String header = "Options:";
        fmt.printHelp("vespa-significance generate [options]", header, CommandLineOptions.createGenerateOptions(), "", false);
    }

    public static ClientParameters parseGenerateCommandLineArguments(CommandLine cl) {
        ClientParameters.Builder builder = new ClientParameters.Builder();
        builder.setHelp(cl.hasOption(HELP_OPTION));
        builder.setInputFile(cl.getOptionValue(INPUT_OPTION));
        builder.setOutputFile(cl.getOptionValue(OUTPUT_OPTION));
        builder.setField(cl.getOptionValue(FIELD_OPTION));
        builder.setLanguage(cl.getOptionValue(LANGUAGE_OPTION));
        builder.setZstCompression(cl.hasOption(ZST_COMPRESSION) ? cl.getOptionValue(ZST_COMPRESSION) : "false");
        return builder.build();
    }

    static Options createExportOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show this help and exit.").build());
        options.addOption(Option.builder().longOpt(INDEX_DIR).hasArg().argName("path/to/index").desc("Path to index directory.").build());
        options.addOption(Option.builder().longOpt(OUTPUT_OPTION).hasArg().argName("FILE.tsv[.zst]").desc("Output TSV file.").build());
        options.addOption(Option.builder().longOpt(FIELD_OPTION).required().hasArg().argName("FIELD").desc("Field to export.").build());
        options.addOption(Option.builder().longOpt(CLUSTER_OPTION).hasArg().argName("NAME").desc("Cluster name.").build());
        options.addOption(Option.builder().longOpt(SCHEMA_NAME).hasArg().argName("NAME").desc("Schema name (document type).").build());
        options.addOption(Option.builder().longOpt(NODE_INDEX_OPTION).hasArg().argName("NUMBER").desc("Node index directory.").build());
        options.addOption(Option.builder((String)"zst").longOpt(ZST_COMPRESSION).desc("Use Zstandard compression.").build());
        return options;
    }

    public static void printExportHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(100);
        fmt.setLeftPadding(2);
        fmt.setDescPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        String header = "Options:";
        fmt.printHelp("vespa-significance export [options]", header, CommandLineOptions.createExportOptions(), "", false);
    }

    public static ExportClientParameters parseExportCommandLineArguments(CommandLine cl) {
        return ExportClientParameters.builder().fieldName(cl.getOptionValue(FIELD_OPTION)).outputFile(cl.hasOption(OUTPUT_OPTION) ? cl.getOptionValue(OUTPUT_OPTION) : "term_df.tsv").indexDir(cl.getOptionValue(INDEX_DIR)).clusterName(cl.getOptionValue(CLUSTER_OPTION)).schemaName(cl.getOptionValue(SCHEMA_NAME)).nodeIndex(cl.getOptionValue(NODE_INDEX_OPTION)).zstCompress(cl.hasOption(ZST_COMPRESSION)).build();
    }

    static class Utils {
        Utils() {
        }

        static boolean hasHelpOption(String[] args) {
            for (String arg : args) {
                if (!List.of("--help", "-h").contains(arg)) continue;
                return true;
            }
            return false;
        }
    }
}

