/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.merge;

import ai.vespa.vespasignificance.merge.FileHandleBudget;
import ai.vespa.vespasignificance.merge.TermDfKWayMerge;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Stream;

public class TermDfExternalMerger {
    private static final long NO_MIN_KEEP = Long.MIN_VALUE;
    private final FileHandleBudget fileHandleBudget;
    private final List<Path> files;
    private final BufferedReaderFactory readerFactory;

    public TermDfExternalMerger(FileHandleBudget fileHandleBudget, List<Path> files, BufferedReaderFactory readerFactory) {
        this.fileHandleBudget = Objects.requireNonNull(fileHandleBudget, "fileHandleBudget");
        this.files = List.copyOf(files);
        this.readerFactory = Objects.requireNonNull(readerFactory, "readerFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFiles(BufferedWriter output, long minKeep) throws IOException {
        Objects.requireNonNull(output, "output");
        if (this.files.isEmpty()) {
            return;
        }
        int budget = this.computeReaderBudget();
        if (budget >= this.files.size()) {
            ArrayList<BufferedReader> readers = new ArrayList<BufferedReader>(this.files.size());
            try {
                for (Path p : this.files) {
                    readers.add(this.readerFactory.open(p));
                }
                TermDfKWayMerge.merge(readers, output, minKeep);
            }
            finally {
                TermDfExternalMerger.closeQuietly(readers);
            }
            return;
        }
        ArrayDeque<MergeSource> filesToMerge = new ArrayDeque<MergeSource>();
        for (Path p : this.files) {
            filesToMerge.offer(new MergeSource(SourceType.External, p));
        }
        Path tempDir = Files.createTempDirectory("termdf-", new FileAttribute[0]);
        try {
            while (filesToMerge.size() > budget) {
                MergeBatch batch = this.dequeueBatch(budget, filesToMerge);
                Path tempFile = Files.createTempFile(tempDir, "termdf-", ".tmp.tsv", new FileAttribute[0]);
                try (BufferedWriter tmpWriter = Files.newBufferedWriter(tempFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE);){
                    TermDfKWayMerge.merge(batch.readers(), tmpWriter, Long.MIN_VALUE);
                }
                catch (Throwable throwable) {
                    TermDfExternalMerger.closeQuietly(batch.readers());
                    for (MergeSource e : batch.consumed()) {
                        if (e.type != SourceType.Tempfile) continue;
                        TermDfExternalMerger.deleteQuietly(e.path);
                    }
                    throw throwable;
                }
                TermDfExternalMerger.closeQuietly(batch.readers());
                for (MergeSource e : batch.consumed()) {
                    if (e.type != SourceType.Tempfile) continue;
                    TermDfExternalMerger.deleteQuietly(e.path);
                }
                filesToMerge.offer(new MergeSource(SourceType.Tempfile, tempFile));
            }
            MergeBatch finalBatch = this.dequeueBatch(budget, filesToMerge);
            try {
                TermDfKWayMerge.merge(finalBatch.readers(), output, minKeep);
            }
            catch (Throwable throwable) {
                TermDfExternalMerger.closeQuietly(finalBatch.readers());
                for (MergeSource e : finalBatch.consumed()) {
                    if (e.type != SourceType.Tempfile) continue;
                    TermDfExternalMerger.deleteQuietly(e.path);
                }
                throw throwable;
            }
            TermDfExternalMerger.closeQuietly(finalBatch.readers());
            for (MergeSource e : finalBatch.consumed()) {
                if (e.type != SourceType.Tempfile) continue;
                TermDfExternalMerger.deleteQuietly(e.path);
            }
        }
        finally {
            TermDfExternalMerger.deleteTreeQuietly(tempDir);
        }
    }

    private int computeReaderBudget() {
        long budget = this.fileHandleBudget.maxReadersAllowed();
        if (budget < 3L) {
            throw new IllegalArgumentException("Cannot merge with less than 3 file handles.");
        }
        long rawReaderBudget = budget - 1L;
        int readerBudget = rawReaderBudget >= (long)this.files.size() ? this.files.size() : (int)rawReaderBudget;
        return readerBudget;
    }

    private MergeBatch dequeueBatch(int readerBudget, Queue<MergeSource> filesToMerge) throws IOException {
        ArrayList<BufferedReader> readers = new ArrayList<BufferedReader>(readerBudget);
        ArrayList<MergeSource> consumed = new ArrayList<MergeSource>(readerBudget);
        while (!filesToMerge.isEmpty() && readers.size() < readerBudget) {
            MergeSource entry = filesToMerge.poll();
            consumed.add(entry);
            BufferedReader r = entry.type == SourceType.Tempfile ? Files.newBufferedReader(entry.path, StandardCharsets.UTF_8) : this.readerFactory.open(entry.path);
            readers.add(r);
        }
        return new MergeBatch(readers, consumed);
    }

    private static void closeQuietly(List<BufferedReader> readers) {
        for (BufferedReader r : readers) {
            try {
                if (r == null) continue;
                r.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void deleteQuietly(Path p) {
        try {
            Files.deleteIfExists(p);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void deleteTreeQuietly(Path dir) {
        try (Stream<Path> s = Files.walk(dir, new FileVisitOption[0]);){
            s.sorted((a, b) -> b.getNameCount() - a.getNameCount()).forEach(p -> {
                try {
                    Files.deleteIfExists(p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface BufferedReaderFactory {
        public BufferedReader open(Path var1) throws IOException;
    }

    record MergeSource(SourceType type, Path path) {
    }

    static enum SourceType {
        External,
        Tempfile;

    }

    private record MergeBatch(List<BufferedReader> readers, List<MergeSource> consumed) {
    }
}

