/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespasignificance;

import com.yahoo.vespasignificance.ClientParameters;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CommandLineOptions {
    public static final String HELP_OPTION = "help";
    public static final String INPUT_OPTION = "in";
    public static final String OUTPUT_OPTION = "out";
    public static final String FIELD_OPTION = "field";
    public static final String LANGUAGE_OPTION = "language";
    public static final String ZST_COMPRESSION = "zst-compression";

    static Options createGlobalOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show available commands.").build());
        return options;
    }

    static Map<String, String> registeredCommands() {
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        commands.put("generate", "Generate a significance model from a JSONL feed file.");
        return commands;
    }

    static void printGlobalHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(100);
        fmt.setLeftPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        Comparator byName = String.CASE_INSENSITIVE_ORDER;
        StringBuilder header = new StringBuilder("Commands:\n");
        CommandLineOptions.registeredCommands().entrySet().stream().sorted(Map.Entry.comparingByKey(byName)).forEach(e -> header.append(String.format("  %-12s %s%n", e.getKey(), e.getValue())));
        header.append("\nOptions:");
        fmt.printHelp("vespa-significance <command>", header.toString(), CommandLineOptions.createGlobalOptions(), "", true);
    }

    static Options createGenerateOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show this help and exit.").build());
        options.addOption(Option.builder((String)"i").longOpt(INPUT_OPTION).required().hasArg().argName("file.jsonl").desc("Input JSON Lines file. One Vespa document per line.").build());
        options.addOption(Option.builder((String)"o").longOpt(OUTPUT_OPTION).required().hasArg().argName("model.json[.zst]").desc("Output model file.").build());
        options.addOption(Option.builder((String)"f").longOpt(FIELD_OPTION).required().hasArg().argName("fieldName").desc("Document field to analyze.").build());
        options.addOption(Option.builder((String)"l").longOpt(LANGUAGE_OPTION).required().hasArg().argName("tag[,tag...]").desc("ISO language tag(s), comma-separated (e.g., 'en', 'no', or 'en,no').").build());
        options.addOption(Option.builder((String)"zst").longOpt(ZST_COMPRESSION).hasArg().argName("true|false").desc("Use Zstandard compression (default: false). If true, --out must end with .zst.").build());
        return options;
    }

    public static void printGenerateHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(100);
        fmt.setLeftPadding(2);
        fmt.setDescPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        String header = "Options:";
        fmt.printHelp("vespa-significance generate", header, CommandLineOptions.createGenerateOptions(), "", true);
    }

    public static ClientParameters parseGenerateCommandLineArguments(CommandLine cl) {
        ClientParameters.Builder builder = new ClientParameters.Builder();
        builder.setHelp(cl.hasOption(HELP_OPTION));
        builder.setInputFile(cl.getOptionValue(INPUT_OPTION));
        builder.setOutputFile(cl.getOptionValue(OUTPUT_OPTION));
        builder.setField(cl.getOptionValue(FIELD_OPTION));
        builder.setLanguage(cl.getOptionValue(LANGUAGE_OPTION));
        builder.setZstCompression(cl.hasOption(ZST_COMPRESSION) ? cl.getOptionValue(ZST_COMPRESSION) : "false");
        return builder.build();
    }

    static class Utils {
        Utils() {
        }

        static boolean hasHelpOption(String[] args) {
            for (String arg : args) {
                if (!List.of("--help", "-h").contains(arg)) continue;
                return true;
            }
            return false;
        }
    }
}

