/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution.status;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.yahoo.json.Jackson;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.airline.Option;
import io.airlift.airline.SingleCommand;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Timeout;

public class FileDistributionStatusClient {
    private static final String statusUnknown = "UNKNOWN";
    private static final String statusInProgress = "IN_PROGRESS";
    private static final String statusFinished = "FINISHED";
    private final String tenantName;
    private final String applicationName;
    private final String instanceName;
    private final String environment;
    private final String region;
    private final double timeout;
    private final boolean debug;

    FileDistributionStatusClient(CommandLineArguments arguments) {
        this.tenantName = arguments.getTenantName();
        this.applicationName = arguments.getApplicationName();
        this.instanceName = arguments.getInstanceName();
        this.environment = arguments.getEnvironment();
        this.region = arguments.getRegion();
        this.timeout = arguments.getTimeout();
        this.debug = arguments.getDebugFlag();
    }

    public static void main(String[] args) {
        try {
            new FileDistributionStatusClient(CommandLineArguments.build(args)).run();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public void run() {
        String json = this.doHttpRequest();
        System.out.println(this.parseAndGenerateOutput(json));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doHttpRequest() {
        Timeout timeoutInMillis = Timeout.ofMilliseconds((long)((long)(this.timeout * 1000.0)));
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(timeoutInMillis).setResponseTimeout(timeoutInMillis).build();
        try (CloseableHttpClient httpClient = VespaHttpClientBuilder.custom().connectTimeout(timeoutInMillis).buildClient();){
            URI statusUri = this.createStatusApiUri();
            if (this.debug) {
                System.out.println("URI:" + String.valueOf(statusUri));
            }
            HttpGet request = new HttpGet(statusUri);
            request.addHeader("Connection", (Object)"Close");
            request.setConfig(config);
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)request);
            HttpEntity entity = response.getEntity();
            String content = EntityUtils.toString((HttpEntity)entity);
            if (this.debug) {
                System.out.println("response:" + content);
            }
            if (response.getCode() != 200) throw new RuntimeException("Failed to get status for request " + String.valueOf(statusUri) + ": " + response.getCode() + ": " + content);
            String string = content;
            return string;
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    String parseAndGenerateOutput(String json) {
        String status;
        JsonNode jsonNode;
        try {
            jsonNode = Jackson.mapper().readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return switch (status = jsonNode.get("status").asText()) {
            case statusUnknown -> "File distribution status unknown: " + jsonNode.get("message").asText();
            case statusInProgress -> "File distribution in progress:\n" + this.inProgressOutput(jsonNode.get("hosts"));
            case statusFinished -> "File distribution finished";
            default -> throw new RuntimeException("Unknown status " + status);
        };
    }

    private URI createStatusApiUri() {
        String path = String.format("/application/v2/tenant/%s/application/%s/environment/%s/region/%s/instance/%s/filedistributionstatus", this.tenantName, this.applicationName, this.environment, this.region, this.instanceName);
        try {
            return new URIBuilder().setScheme("http").setHost("localhost").setPort(19071).setPath(path).addParameter("timeout", String.valueOf(this.timeout)).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String inProgressOutput(JsonNode hosts) {
        ArrayList<String> statusPerHost = new ArrayList<String>();
        for (JsonNode host : hosts) {
            String status = host.get("status").asText();
            StringBuilder sb = new StringBuilder(host.get("hostname").asText()).append(": ").append(status);
            switch (status) {
                case "UNKNOWN": {
                    sb.append(" (").append(host.get("message").asText()).append(")");
                    break;
                }
                case "IN_PROGRESS": {
                    JsonNode fileReferencesArray = host.get("fileReferences");
                    int finished = 0;
                    for (JsonNode element : fileReferencesArray) {
                        Iterator it = element.fields();
                        while (it.hasNext()) {
                            Map.Entry fileReferenceStatus = (Map.Entry)it.next();
                            if (((JsonNode)fileReferenceStatus.getValue()).asDouble() != 1.0) continue;
                            ++finished;
                        }
                    }
                    sb.append(" (").append(finished).append(" of ").append(fileReferencesArray.size()).append(" finished)");
                    break;
                }
                case "FINISHED": {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown status " + status);
                }
            }
            statusPerHost.add(sb.toString());
        }
        return String.join((CharSequence)"\n", statusPerHost);
    }

    @Command(name="vespa-status-filedistribution", description="Tool for getting file distribution status.")
    public static class CommandLineArguments {
        @Inject
        HelpOption helpOption;
        @Option(name={"--tenant"}, description="tenant name")
        private String tenantNameArg;
        @Option(name={"--application"}, description="application name")
        private String applicationNameArg;
        @Option(name={"--instance"}, description="instance name")
        private String instanceNameArg = "default";
        @Option(name={"--environment"}, description="environment name")
        private String environmentArg = "prod";
        @Option(name={"--region"}, description="region name")
        private String regionArg = "default";
        @Option(name={"--timeout"}, description="The timeout (in seconds).")
        private double timeoutArg = 5.0;
        @Option(name={"--debug"}, description="Print debug log.")
        private boolean debugArg;

        static CommandLineArguments build(String[] args) {
            CommandLineArguments arguments = null;
            try {
                arguments = (CommandLineArguments)SingleCommand.singleCommand(CommandLineArguments.class).parse(args);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println("Use --help to show usage.\n");
                System.exit(1);
            }
            if (arguments.helpOption.showHelpIfRequested()) {
                System.exit(0);
            }
            if (arguments.getTenantName() == null) {
                System.err.println("'--tenant' not set.");
                System.exit(1);
            }
            if (arguments.getApplicationName() == null) {
                System.err.println("'--application' not set.");
                System.exit(1);
            }
            return arguments;
        }

        public String getTenantName() {
            return this.tenantNameArg;
        }

        public String getApplicationName() {
            return this.applicationNameArg;
        }

        public String getInstanceName() {
            return this.instanceNameArg;
        }

        public String getEnvironment() {
            return this.environmentArg;
        }

        public String getRegion() {
            return this.regionArg;
        }

        public double getTimeout() {
            return this.timeoutArg;
        }

        public boolean getDebugFlag() {
            return this.debugArg;
        }
    }
}

