/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespasignificance;

import com.yahoo.vespasignificance.ClientParameters;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineOptions {
    public static final String HELP_OPTION = "help";
    public static final String INPUT_OPTION = "in";
    public static final String OUTPUT_OPTION = "out";
    public static final String FIELD_OPTION = "field";
    public static final String LANGUAGE_OPTION = "language";
    public static final String DOC_TYPE_OPTION = "doc-type";
    public static final String ZST_COMPRESSION = "zst-compression";
    private final Options options = CommandLineOptions.createOptions();

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").hasArg(false).desc("Show this syntax page.").longOpt(HELP_OPTION).build());
        options.addOption(Option.builder((String)"i").required().hasArg(true).desc("Input file").longOpt(INPUT_OPTION).build());
        options.addOption(Option.builder((String)"o").required().hasArg(true).desc("Output file").longOpt(OUTPUT_OPTION).build());
        options.addOption(Option.builder((String)"f").required().hasArg(true).desc("Field to analyze").longOpt(FIELD_OPTION).build());
        options.addOption(Option.builder((String)"l").required().hasArg(true).desc("Language tag for output file").longOpt(LANGUAGE_OPTION).build());
        options.addOption(Option.builder((String)"d").required().hasArg(true).desc("Document type identifier").longOpt(DOC_TYPE_OPTION).build());
        options.addOption(Option.builder((String)"zst").hasArg(true).desc("Use Zstandard compression").longOpt(ZST_COMPRESSION).build());
        return options;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("vespa-significance <command> <options>", "Perform a significance value related operation.", this.options, "The generate command generates a significance model file for a given corpus type .jsonl file.\n", false);
    }

    public ClientParameters parseCommandLineArguments(String[] args) throws IllegalArgumentException {
        try {
            DefaultParser clp = new DefaultParser();
            CommandLine cl = clp.parse(this.options, args);
            ClientParameters.Builder builder = new ClientParameters.Builder();
            builder.setHelp(cl.hasOption(HELP_OPTION));
            builder.setInputFile(cl.getOptionValue(INPUT_OPTION));
            builder.setOutputFile(cl.getOptionValue(OUTPUT_OPTION));
            builder.setField(cl.getOptionValue(FIELD_OPTION));
            builder.setLanguage(cl.getOptionValue(LANGUAGE_OPTION));
            builder.setDocType(cl.getOptionValue(DOC_TYPE_OPTION));
            builder.setZstCompression(cl.hasOption(ZST_COMPRESSION) ? cl.getOptionValue(ZST_COMPRESSION) : "true");
            return builder.build();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse command line arguments: " + e.getMessage());
        }
    }
}

