/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.security.KeyId;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SecretSharedKey;
import com.yahoo.security.SharedKeyGenerator;
import com.yahoo.security.SharedKeyResealingSession;
import com.yahoo.vespa.security.tool.CliUtils;
import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import com.yahoo.vespa.security.tool.ToolInvocation;
import com.yahoo.vespa.security.tool.crypto.ToolUtils;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.List;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class ResealTool
implements Tool {
    static final String EXPECTED_KEY_ID_OPTION = "expected-key-id";
    static final String RECIPIENT_KEY_ID_OPTION = "key-id";
    static final String RECIPIENT_PUBLIC_KEY_OPTION = "recipient-public-key";
    static final String RESEAL_REQUEST_OPTION = "reseal-request";
    private static final List<Option> OPTIONS = List.of(Option.builder((String)"k").longOpt("private-key-file").hasArg(true).required(false).desc("Private key file in Base58 encoded format").build(), Option.builder((String)"d").longOpt("private-key-dir").hasArg(true).required(false).desc("Private key file directory used for automatically looking up private keys based on the key ID specified as part of a token.").build(), Option.builder().longOpt("no-interactive").hasArg(false).required(false).desc("Never ask for private key interactively if no private key file or directory is provided, even if process is running in a console").build(), Option.builder((String)"e").longOpt("expected-key-id").hasArg(true).required(false).desc("Expected key ID in token. If this is not provided, the key ID is not verified.").build(), Option.builder((String)"r").longOpt("recipient-public-key").hasArg(true).required(false).desc("Recipient X25519 public key in Base58 encoded format").build(), Option.builder((String)"i").longOpt("key-id").hasArg(true).required(false).desc("ID of recipient key").build(), Option.builder().longOpt("reseal-request").hasArg(false).required(false).desc("Handle input as a resealing request instead of a token").build());

    @Override
    public String name() {
        return "reseal";
    }

    @Override
    public ToolDescription description() {
        return new ToolDescription("<token> <options>", "Reseals the input token for another recipient, allowing that recipient to decrypt the file that the input token was originally created for.\nPrints new token to STDOUT.", "Note: this is a BETA tool version; its interface may be changed at any time", OPTIONS);
    }

    @Override
    public int invoke(ToolInvocation invocation) {
        try {
            CommandLine arguments = invocation.arguments();
            String[] leftoverArgs = arguments.getArgs();
            if (leftoverArgs.length != 1) {
                throw new IllegalArgumentException("Expected exactly 1 token argument to re-seal");
            }
            String inputArg = leftoverArgs[0].strip();
            Optional<Object> maybeKeyId = Optional.ofNullable(arguments.hasOption(EXPECTED_KEY_ID_OPTION) ? arguments.getOptionValue(EXPECTED_KEY_ID_OPTION) : null);
            if (arguments.hasOption(RESEAL_REQUEST_OPTION)) {
                ResealTool.handleResealingRequest(invocation, inputArg, maybeKeyId);
            } else {
                ResealTool.handleTokenResealing(invocation, arguments, inputArg, maybeKeyId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private static void handleTokenResealing(ToolInvocation invocation, CommandLine arguments, String inputArg, Optional<String> maybeKeyId) throws IOException {
        SealedSharedKey sealedSharedKey = SealedSharedKey.fromTokenString((String)inputArg);
        ToolUtils.verifyExpectedKeyId(sealedSharedKey, maybeKeyId);
        XECPublicKey recipientPubKey = KeyUtils.fromBase58EncodedX25519PublicKey((String)CliUtils.optionOrThrow(arguments, RECIPIENT_PUBLIC_KEY_OPTION).strip());
        KeyId recipientKeyId = KeyId.ofString((String)CliUtils.optionOrThrow(arguments, RECIPIENT_KEY_ID_OPTION));
        XECPrivateKey privateKey = ToolUtils.resolvePrivateKeyFromInvocation(invocation, sealedSharedKey.keyId(), true);
        SecretSharedKey secretShared = SharedKeyGenerator.fromSealedKey((SealedSharedKey)sealedSharedKey, (PrivateKey)privateKey);
        SecretSharedKey resealedShared = SharedKeyGenerator.reseal((SecretSharedKey)secretShared, (PublicKey)recipientPubKey, (KeyId)recipientKeyId);
        invocation.stdOut().println(resealedShared.sealedSharedKey().toTokenString());
    }

    private static void handleResealingRequest(ToolInvocation invocation, String inputArg, Optional<String> maybeKeyId) throws IOException {
        SharedKeyResealingSession.ResealingRequest request = SharedKeyResealingSession.ResealingRequest.fromSerializedString((String)inputArg);
        ToolUtils.verifyExpectedKeyId(request.sealedKey(), maybeKeyId);
        XECPrivateKey privateKey = ToolUtils.resolvePrivateKeyFromInvocation(invocation, request.sealedKey().keyId(), true);
        SharedKeyResealingSession.ResealingResponse resealed = SharedKeyResealingSession.reseal((SharedKeyResealingSession.ResealingRequest)request, keyId -> Optional.of(privateKey));
        invocation.stdOut().println(resealed.toSerializedString());
    }
}

