/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool;

import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

class CliOptions {
    private static final Option HELP_OPTION = Option.builder((String)"h").longOpt("help").hasArg(false).required(false).desc("Show help").build();

    CliOptions() {
    }

    static Options withHelpOption(List<Option> options) {
        Options optionsWithHelp = new Options();
        options.forEach(arg_0 -> ((Options)optionsWithHelp).addOption(arg_0));
        optionsWithHelp.addOption(HELP_OPTION);
        return optionsWithHelp;
    }

    static void printTopLevelHelp(PrintStream out, List<Tool> tools) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter writer = new PrintWriter(out);
        formatter.printHelp(writer, formatter.getWidth(), "vespa-security <tool> [TOOL OPTIONS]", "Where <tool> is one of: %s".formatted(tools.stream().map(Tool::name).collect(Collectors.joining(", "))), CliOptions.withHelpOption(List.of()), formatter.getLeftPadding(), formatter.getDescPadding(), "Invoke vespa-security <tool> --help for tool-specific help");
        writer.flush();
    }

    static void printToolSpecificHelp(PrintStream out, String toolName, ToolDescription toolDesc, Options optionsWithHelp) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter writer = new PrintWriter(out);
        formatter.printHelp(writer, formatter.getWidth(), "vespa-security %s %s".formatted(toolName, toolDesc.helpArgSuffix()), toolDesc.helpHeader(), optionsWithHelp, formatter.getLeftPadding(), formatter.getDescPadding(), toolDesc.helpFooter());
        writer.flush();
    }
}

