/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.security.AeadCipher;
import com.yahoo.security.KeyId;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SecretSharedKey;
import com.yahoo.security.SharedKeyGenerator;
import com.yahoo.vespa.security.tool.CliUtils;
import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import com.yahoo.vespa.security.tool.ToolInvocation;
import com.yahoo.vespa.security.tool.crypto.CipherUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.security.interfaces.XECPublicKey;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class EncryptTool
implements Tool {
    static final String OUTPUT_FILE_OPTION = "output-file";
    static final String KEY_ID_OPTION = "key-id";
    static final String RECIPIENT_PUBLIC_KEY_OPTION = "recipient-public-key";
    static final String ZSTD_COMPRESS_OPTION = "zstd-compress";
    private static final List<Option> OPTIONS = List.of(Option.builder((String)"o").longOpt("output-file").hasArg(true).required(false).desc("Output file (will be truncated if it already exists)").build(), Option.builder((String)"r").longOpt("recipient-public-key").hasArg(true).required(false).desc("Recipient X25519 public key in Base58 encoded format").build(), Option.builder((String)"i").longOpt("key-id").hasArg(true).required(false).desc("ID of recipient key").build(), Option.builder((String)"z").longOpt("zstd-compress").hasArg(false).required(false).desc("Input data will be transparently Zstd-compressed before being encrypted.").build());

    @Override
    public String name() {
        return "encrypt";
    }

    @Override
    public ToolDescription description() {
        return new ToolDescription("<input file> <options>", "One-way encrypts a file using the public key of a recipient. A public token is printed on standard out. The recipient can use this token to decrypt the file using their private key. The token does not have to be kept secret.\n\nTo encrypt the contents of STDIN, specify an input file of '-' (without the quotes).", "Note: this is a BETA tool version; its interface may be changed at any time", OPTIONS);
    }

    @Override
    public int invoke(ToolInvocation invocation) {
        try {
            CommandLine arguments = invocation.arguments();
            String[] leftoverArgs = arguments.getArgs();
            if (leftoverArgs.length != 1) {
                throw new IllegalArgumentException("Expected exactly 1 file argument to encrypt");
            }
            String inputArg = leftoverArgs[0];
            Path outputPath = Paths.get(CliUtils.optionOrThrow(arguments, OUTPUT_FILE_OPTION), new String[0]);
            XECPublicKey recipientPubKey = KeyUtils.fromBase58EncodedX25519PublicKey((String)CliUtils.optionOrThrow(arguments, RECIPIENT_PUBLIC_KEY_OPTION).strip());
            KeyId keyId = KeyId.ofString((String)CliUtils.optionOrThrow(arguments, KEY_ID_OPTION));
            SecretSharedKey shared = SharedKeyGenerator.generateForReceiverPublicKey((PublicKey)recipientPubKey, (KeyId)keyId);
            AeadCipher cipher = shared.makeEncryptionCipher();
            boolean zstd = arguments.hasOption(ZSTD_COMPRESS_OPTION);
            try (InputStream inStream = CliUtils.inputStreamFromFileOrStream(inputArg, invocation.stdIn());
                 OutputStream outStream = Files.newOutputStream(outputPath, new OpenOption[0]);){
                CipherUtils.streamEncrypt(inStream, outStream, cipher, zstd);
            }
            invocation.stdOut().println(shared.sealedSharedKey().toTokenString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }
}

