/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.security.AeadCipher;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SecretSharedKey;
import com.yahoo.security.SharedKeyGenerator;
import com.yahoo.security.SharedKeyResealingSession;
import com.yahoo.vespa.security.tool.CliUtils;
import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import com.yahoo.vespa.security.tool.ToolInvocation;
import com.yahoo.vespa.security.tool.crypto.CipherUtils;
import com.yahoo.vespa.security.tool.crypto.ToolUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.interfaces.XECPrivateKey;
import java.util.List;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class DecryptTool
implements Tool {
    static final String OUTPUT_FILE_OPTION = "output-file";
    static final String EXPECTED_KEY_ID_OPTION = "expected-key-id";
    static final String ZSTD_DECOMPRESS_OPTION = "zstd-decompress";
    static final String TOKEN_OPTION = "token";
    static final String RESEAL_REQUEST = "reseal-request";
    private static final List<Option> OPTIONS = List.of(Option.builder((String)"o").longOpt("output-file").hasArg(true).required(false).desc("Output file for decrypted plaintext. Specify '-' (without the quotes) to write plaintext to STDOUT instead of a file.").build(), Option.builder((String)"k").longOpt("private-key-file").hasArg(true).required(false).desc("Private key file in Base58 encoded format").build(), Option.builder((String)"d").longOpt("private-key-dir").hasArg(true).required(false).desc("Private key file directory used for automatically looking up private keys based on the key ID specified as part of a token.").build(), Option.builder().longOpt("no-interactive").hasArg(false).required(false).desc("Never ask for private key interactively if no private key file or directory is provided, even if process is running in a console").build(), Option.builder((String)"e").longOpt("expected-key-id").hasArg(true).required(false).desc("Expected key ID in token. If this is not provided, the key ID is not verified.").build(), Option.builder((String)"z").longOpt("zstd-decompress").hasArg(false).required(false).desc("Decrypted data will be transparently Zstd-decompressed before being output.").build(), Option.builder((String)"t").longOpt("token").hasArg(true).required(false).desc("Token generated when the input file was encrypted").build(), Option.builder((String)"r").longOpt("reseal-request").hasArg(false).required(false).desc("Delegate private key decryption via an interactive resealing session").build());

    @Override
    public String name() {
        return "decrypt";
    }

    @Override
    public ToolDescription description() {
        return new ToolDescription("<encrypted file> <options>", "Decrypts a file using a provided token and a secret private key. The file must previously have been encrypted using the public key component of the given private key.\n\nTo decrypt the contents of STDIN, specify an input file of '-' (without the quotes).", "Note: this is a BETA tool version; its interface may be changed at any time", OPTIONS);
    }

    @Override
    public int invoke(ToolInvocation invocation) {
        try {
            CommandLine arguments = invocation.arguments();
            String[] leftoverArgs = arguments.getArgs();
            if (leftoverArgs.length != 1) {
                throw new IllegalArgumentException("Expected exactly 1 file argument to decrypt");
            }
            String inputArg = leftoverArgs[0];
            Optional<String> maybeKeyId = Optional.ofNullable(arguments.getOptionValue(EXPECTED_KEY_ID_OPTION));
            String outputArg = CliUtils.optionOrThrow(arguments, OUTPUT_FILE_OPTION);
            String tokenString = CliUtils.optionOrThrow(arguments, TOKEN_OPTION);
            SealedSharedKey sealedSharedKey = SealedSharedKey.fromTokenString((String)tokenString.strip());
            ToolUtils.verifyExpectedKeyId(sealedSharedKey, maybeKeyId);
            SecretSharedKey secret = arguments.hasOption(RESEAL_REQUEST) ? DecryptTool.secretFromInteractiveResealing(invocation, inputArg, outputArg, sealedSharedKey) : DecryptTool.secretFromPrivateKey(invocation, inputArg, outputArg, sealedSharedKey);
            AeadCipher cipher = secret.makeDecryptionCipher();
            boolean unZstd = arguments.hasOption(ZSTD_DECOMPRESS_OPTION);
            try (InputStream inStream = CliUtils.inputStreamFromFileOrStream(inputArg, invocation.stdIn());
                 OutputStream outStream = CliUtils.outputStreamToFileOrStream(outputArg, invocation.stdOut());){
                CipherUtils.streamDecrypt(inStream, outStream, cipher, unZstd);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private static SecretSharedKey secretFromPrivateKey(ToolInvocation invocation, String inputArg, String outputArg, SealedSharedKey sealedSharedKey) throws IOException {
        XECPrivateKey privateKey = ToolUtils.resolvePrivateKeyFromInvocation(invocation, sealedSharedKey.keyId(), !CliUtils.useStdIo(inputArg) && !CliUtils.useStdIo(outputArg));
        return SharedKeyGenerator.fromSealedKey((SealedSharedKey)sealedSharedKey, (PrivateKey)privateKey);
    }

    private static SecretSharedKey secretFromInteractiveResealing(ToolInvocation invocation, String inputArg, String outputArg, SealedSharedKey sealedSharedKey) throws IOException {
        if (CliUtils.useStdIo(outputArg) || CliUtils.useStdIo(inputArg)) {
            throw new IllegalArgumentException("Interactive token resealing not available with redirected I/O");
        }
        SharedKeyResealingSession session = SharedKeyResealingSession.newEphemeralSession();
        SharedKeyResealingSession.ResealingRequest req = session.resealingRequestFor(sealedSharedKey);
        invocation.stdOut().format("\nInteractive token resealing request:\n\n%s\n\n", req.toSerializedString());
        invocation.stdOut().format("Paste response and hit return: ", new Object[0]);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(invocation.stdIn()));){
            String serializedRes = reader.readLine().strip();
            if (serializedRes.isEmpty()) {
                throw new IllegalArgumentException("Empty response; aborting");
            }
            SharedKeyResealingSession.ResealingResponse res = SharedKeyResealingSession.ResealingResponse.fromSerializedString((String)serializedRes);
            SecretSharedKey secretSharedKey = session.openResealingResponse(res);
            return secretSharedKey;
        }
    }
}

