/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespastat;

import com.yahoo.vespastat.BucketStatsException;
import com.yahoo.vespastat.BucketStatsPrinter;
import com.yahoo.vespastat.BucketStatsRetriever;
import com.yahoo.vespastat.ClientParameters;
import com.yahoo.vespastat.CommandLineOptions;
import com.yahoo.vespastat.DocumentAccessFactory;

public class Main {
    private Main() {
    }

    public static void main(String[] args) {
        CommandLineOptions options = new CommandLineOptions();
        try {
            ClientParameters params = options.parseCommandLineArguments(args);
            if (params.help) {
                options.printHelp();
                return;
            }
            BucketStatsRetriever retriever = new BucketStatsRetriever(new DocumentAccessFactory(), params.route, Main.createShutdownHookRegistrar());
            BucketStatsPrinter printer = new BucketStatsPrinter(retriever, System.out);
            printer.retrieveAndPrintBucketStats(params.selectionType, params.id, params.dumpData, params.bucketSpace);
        }
        catch (IllegalArgumentException e) {
            System.err.printf("Failed to parse command line arguments: %s.\n", e.getMessage());
        }
        catch (BucketStatsException e) {
            System.err.println(e.getMessage());
        }
    }

    private static BucketStatsRetriever.ShutdownHookRegistrar createShutdownHookRegistrar() {
        return runnable -> Runtime.getRuntime().addShutdownHook(new Thread(runnable));
    }
}

