/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespastat;

import com.yahoo.document.BucketId;
import com.yahoo.documentapi.messagebus.protocol.GetBucketListReply;
import com.yahoo.vespastat.BucketStatsException;
import com.yahoo.vespastat.BucketStatsRetriever;
import com.yahoo.vespastat.ClientParameters;
import java.io.PrintStream;
import java.util.List;

public class BucketStatsPrinter {
    private final BucketStatsRetriever retriever;
    private final PrintStream out;

    public BucketStatsPrinter(BucketStatsRetriever retriever, PrintStream out) {
        this.retriever = retriever;
        this.out = out;
    }

    public void retrieveAndPrintBucketStats(ClientParameters.SelectionType type, String id, boolean dumpData, String bucketSpace) throws BucketStatsException {
        BucketId bucketId = this.retriever.getBucketIdForType(type, id);
        if (type == ClientParameters.SelectionType.GROUP || type == ClientParameters.SelectionType.USER) {
            this.out.printf("Generated 32-bit bucket id: %s\n", bucketId);
        }
        List<GetBucketListReply.BucketInfo> bucketList = this.retriever.retrieveBucketList(bucketId, bucketSpace);
        this.printBucketList(bucketList);
        if (dumpData) {
            for (GetBucketListReply.BucketInfo bucketInfo : bucketList) {
                BucketId bucket = bucketInfo.getBucketId();
                String bucketStats = this.retriever.retrieveBucketStats(type, id, bucket, bucketSpace);
                this.printBucketStats(bucket, bucketStats);
            }
        }
    }

    private void printBucketList(List<GetBucketListReply.BucketInfo> bucketList) {
        if (bucketList.isEmpty()) {
            this.out.println("No actual files were stored for this bucket.");
        } else {
            this.out.println("Bucket maps to the following actual files:");
            for (GetBucketListReply.BucketInfo bucketInfo : bucketList) {
                this.out.printf("\t%s\n", bucketInfo);
            }
        }
    }

    private void printBucketStats(BucketId bucket, String stats) {
        this.out.printf("\nDetails for %s:\n%s", bucket, stats);
    }
}

