/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.dummyreceiver;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.documentapi.ThroughputLimitQueue;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.log.LogSetup;
import com.yahoo.messagebus.DestinationSession;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.network.Identity;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DummyReceiver
implements MessageHandler {
    String name = null;
    DestinationSession session;
    MessageBusDocumentAccess da;
    long sleepTime = 0L;
    long messageCount = 0L;
    int maxPendingCount = 0;
    long silentNum = 0L;
    boolean instant = false;
    ThreadPoolExecutor executor = null;
    int threads = 10;
    long maxQueueTime = -1L;
    BlockingQueue<Runnable> queue;
    boolean verbose = false;
    private boolean helpOption = false;

    DummyReceiver() {
    }

    public void init() {
        MessageBusParams params = new MessageBusParams(new LoadTypeSet());
        params.setRPCNetworkParams(new RPCNetworkParams().setIdentity(new Identity(this.name)));
        params.setDocumentManagerConfigId("client");
        params.getMessageBusParams().setMaxPendingCount(this.maxPendingCount);
        params.getMessageBusParams().setMaxPendingSize(0);
        this.da = new MessageBusDocumentAccess(params);
        this.queue = this.maxQueueTime < 0L ? new LinkedBlockingDeque<Runnable>() : new ThroughputLimitQueue(this.maxQueueTime);
        this.session = this.da.getMessageBus().createDestinationSession("default", true, (MessageHandler)this);
        this.executor = new ThreadPoolExecutor(this.threads, this.threads, 5L, TimeUnit.SECONDS, this.queue, (ThreadFactory)new DaemonThreadFactory());
        System.out.println("Registered listener at " + this.name + "/default with " + this.maxPendingCount + " max pending and sleep time of " + this.sleepTime);
    }

    public void handleMessage(Message message) {
        ++this.messageCount;
        if (this.silentNum == 0L) {
            System.out.println("Received message " + message + ". Received " + this.messageCount + " messages so far. In queue size " + this.queue.size());
            if (this.verbose) {
                if (message instanceof PutDocumentMessage) {
                    System.out.println("  Document:\n" + ((PutDocumentMessage)message).getDocumentPut().getDocument().toXML("  "));
                } else if (message instanceof RemoveDocumentMessage) {
                    System.out.println("  Document id: " + ((RemoveDocumentMessage)message).getDocumentId());
                } else if (message instanceof UpdateDocumentMessage) {
                    System.out.println("  Update:\n  " + ((UpdateDocumentMessage)message).getDocumentUpdate().toString());
                }
            }
        } else if (this.messageCount % this.silentNum == 0L) {
            System.out.println("Received " + this.messageCount + " messages so far. In queue size " + this.queue.size());
        }
        EmptyReply reply = new EmptyReply();
        message.swapState((Routable)reply);
        if (!this.instant) {
            try {
                this.executor.execute(new Task((Reply)reply));
            }
            catch (RejectedExecutionException e) {
                reply.addError(new Error(100005, "Session " + this.name + "/default is busy"));
                this.session.reply((Reply)reply);
            }
        } else {
            this.session.reply((Reply)reply);
        }
    }

    String getParam(List<String> args, String arg) throws IllegalArgumentException {
        try {
            return args.remove(0);
        }
        catch (Exception e) {
            System.err.println("--" + arg + " requires an argument");
            throw new IllegalArgumentException(arg);
        }
    }

    public void help() {
        System.out.println("Simple receiver for messagebus messages. Prints the messages received to stdout.\n\nThe options are:\n  --instant          Reply in message thread.  --name arg         Slobrok name to register\n  --maxqueuetime arg Adjust the in queue size to have a maximum queue wait period of this many ms (default -1 = unlimited)\n  --silent #nummsg   Do not dump anything, but progress every #nummsg\n  --sleeptime arg    The number of milliseconds to sleep per message, to simulate processing time\n  --threads arg      The number of threads to process the incoming data\n  --verbose          If set, dump the contents of certain messages to stdout");
    }

    boolean parseArgs(List<String> args) {
        try {
            while (!args.isEmpty()) {
                String arg = args.remove(0);
                if (arg.equals("-h") || arg.equals("--help")) {
                    this.help();
                    this.helpOption = true;
                    return false;
                }
                if ("--name".equals(arg)) {
                    this.name = this.getParam(args, arg);
                    continue;
                }
                if ("--sleeptime".equals(arg)) {
                    this.sleepTime = Long.parseLong(this.getParam(args, arg));
                    continue;
                }
                if ("--instant".equals(arg)) {
                    this.instant = true;
                    continue;
                }
                if ("--silent".equals(arg)) {
                    this.silentNum = Long.parseLong(this.getParam(args, arg));
                    continue;
                }
                if ("--maxqueuetime".equals(arg)) {
                    this.maxQueueTime = Long.parseLong(this.getParam(args, arg));
                    continue;
                }
                if ("--threads".equals(arg)) {
                    this.threads = Integer.parseInt(this.getParam(args, arg));
                    continue;
                }
                if ("--verbose".equals(arg)) {
                    this.verbose = true;
                    continue;
                }
                this.help();
                this.helpOption = true;
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        LogSetup.initVespaLogging((String)"dummyreceiver");
        DummyReceiver rcv = new DummyReceiver();
        LinkedList<String> l = new LinkedList<String>();
        for (String arg : args) {
            l.add(arg);
        }
        if (!rcv.parseArgs(l) && !rcv.helpOption) {
            System.exit(1);
        }
        if (rcv.helpOption) {
            System.exit(0);
        }
        rcv.init();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public class Task
    implements Runnable {
        Reply reply;

        public Task(Reply reply) {
            this.reply = reply;
        }

        @Override
        public void run() {
            if (DummyReceiver.this.sleepTime > 0L) {
                try {
                    Thread.sleep(DummyReceiver.this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            DummyReceiver.this.session.reply(this.reply);
        }
    }
}

