/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.collections.Tuple2;
import com.yahoo.container.handler.threadpool.ContainerThreadPool;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.vespa.http.server.ErrorHttpResponse;
import com.yahoo.vespa.http.server.FeedHandlerV3;
import com.yahoo.vespa.http.server.FeedReplyReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;

public class FeedHandler
extends ThreadedHttpRequestHandler {
    protected final ReplyHandler feedReplyHandler;
    private static final List<Integer> serverSupportedVersions = List.of(Integer.valueOf(3));
    private static final Pattern USER_AGENT_PATTERN = Pattern.compile("vespa-http-client \\((.+)\\)");
    private final FeedHandlerV3 feedHandlerV3;
    private final DocumentApiMetrics metricsHelper;

    @Inject
    public FeedHandler(ContainerThreadPool threadpool, Metric metric, DocumentTypeManager documentTypeManager, SessionCache sessionCache, MetricReceiver metricReceiver) {
        super(threadpool.executor(), metric);
        this.metricsHelper = new DocumentApiMetrics(metricReceiver, "vespa.http.server");
        this.feedHandlerV3 = new FeedHandlerV3(threadpool.executor(), metric, documentTypeManager, sessionCache, this.metricsHelper);
        this.feedReplyHandler = new FeedReplyReader(metric, this.metricsHelper);
    }

    private Tuple2<HttpResponse, Integer> checkProtocolVersion(HttpRequest request) {
        return FeedHandler.doCheckProtocolVersion(request.getJDiscRequest().headers().get((Object)"X-Yahoo-Feed-Protocol-Version"));
    }

    static Tuple2<HttpResponse, Integer> doCheckProtocolVersion(List<String> clientSupportedVersions) {
        List<String> washedClientVersions = FeedHandler.splitVersions(clientSupportedVersions);
        if (washedClientVersions == null || washedClientVersions.isEmpty()) {
            return new Tuple2((Object)new ErrorHttpResponse(406, "Request did not contain X-Yahoo-Feed-Protocol-Versionheader. Server supports protocol versions " + serverSupportedVersions), (Object)-1);
        }
        if (!washedClientVersions.contains("3")) {
            return new Tuple2((Object)new ErrorHttpResponse(406, "Could not parse X-Yahoo-Feed-Protocol-Versionheader of request (values: " + washedClientVersions + "). Server supports protocol versions " + serverSupportedVersions), (Object)-1);
        }
        int version = 3;
        return new Tuple2(null, (Object)version);
    }

    private static List<String> splitVersions(List<String> clientSupportedVersions) {
        ArrayList<String> splittedVersions = new ArrayList<String>();
        for (String v : clientSupportedVersions) {
            if (v == null || v.trim().isEmpty()) continue;
            if (!v.contains(",")) {
                splittedVersions.add(v.trim());
                continue;
            }
            for (String part : v.split(",")) {
                if ((part = part.trim()).isEmpty()) continue;
                splittedVersions.add(part);
            }
        }
        return splittedVersions;
    }

    public HttpResponse handle(HttpRequest request) {
        this.metricsHelper.reportHttpRequest(FeedHandler.findClientVersion(request).orElse(null));
        Tuple2<HttpResponse, Integer> protocolVersion = this.checkProtocolVersion(request);
        if (protocolVersion.first != null) {
            return (HttpResponse)protocolVersion.first;
        }
        return this.feedHandlerV3.handle(request);
    }

    protected void writeErrorResponseOnOverload(Request request, ResponseHandler responseHandler) {
        int responseCode = request.headers().getFirst("X-Yahoo-Silent-Upgrade") != null ? 299 : 429;
        responseHandler.handleResponse(new Response(responseCode)).close(null);
    }

    private static Optional<String> findClientVersion(HttpRequest request) {
        String versionHeader = request.getHeader("Vespa-Client-Version");
        if (versionHeader != null) {
            return Optional.of(versionHeader);
        }
        return Optional.ofNullable(request.getHeader("User-Agent")).map(USER_AGENT_PATTERN::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1));
    }

    protected static InputStream unzipStreamIfNeeded(InputStream inputStream, HttpRequest httpRequest) throws IOException {
        String contentEncodingHeader = httpRequest.getHeader("content-encoding");
        if ("gzip".equals(contentEncodingHeader)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    protected void destroy() {
        this.feedHandlerV3.destroy();
    }
}

