/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.jdisc.Metric;
import com.yahoo.messagebus.Message;
import com.yahoo.vespaxmlparser.FeedOperation;

class DocumentOperationMessageV3 {
    private final String operationId;
    private final Message message;

    private DocumentOperationMessageV3(String operationId, Message message) {
        this.operationId = operationId;
        this.message = message;
    }

    Message getMessage() {
        return this.message;
    }

    String getOperationId() {
        return this.operationId;
    }

    private static DocumentOperationMessageV3 newUpdateMessage(FeedOperation op, String operationId) {
        UpdateDocumentMessage msg = new UpdateDocumentMessage(op.getDocumentUpdate());
        String id = operationId == null ? msg.getDocumentUpdate().getId().toString() : operationId;
        return new DocumentOperationMessageV3(id, (Message)msg);
    }

    static DocumentOperationMessageV3 newRemoveMessage(FeedOperation op, String operationId) {
        RemoveDocumentMessage msg = new RemoveDocumentMessage(op.getDocumentRemove());
        String id = operationId == null ? msg.getDocumentId().toString() : operationId;
        return new DocumentOperationMessageV3(id, (Message)msg);
    }

    private static DocumentOperationMessageV3 newPutMessage(FeedOperation op, String operationId) {
        PutDocumentMessage msg = new PutDocumentMessage(op.getDocumentPut());
        String id = operationId == null ? msg.getDocumentPut().getId().toString() : operationId;
        return new DocumentOperationMessageV3(id, (Message)msg);
    }

    static DocumentOperationMessageV3 create(FeedOperation operation, String operationId, Metric metric) {
        switch (operation.getType()) {
            case DOCUMENT: {
                metric.add("httpapi_num_puts", (Number)1, null);
                return DocumentOperationMessageV3.newPutMessage(operation, operationId);
            }
            case REMOVE: {
                metric.add("httpapi_num_removes", (Number)1, null);
                return DocumentOperationMessageV3.newRemoveMessage(operation, operationId);
            }
            case UPDATE: {
                metric.add("httpapi_num_updates", (Number)1, null);
                return DocumentOperationMessageV3.newUpdateMessage(operation, operationId);
            }
        }
        return null;
    }
}

