/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.vespa.http.client.core.Encoder;
import com.yahoo.vespa.http.server.FeedReaderFactory;
import com.yahoo.vespa.http.server.FeederSettings;
import com.yahoo.vespa.http.server.util.ByteLimitedInputStream;
import com.yahoo.vespaxmlparser.FeedOperation;
import com.yahoo.vespaxmlparser.FeedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class StreamReaderV3 {
    protected static final Logger log = Logger.getLogger(StreamReaderV3.class.getName());
    private final FeedReaderFactory feedReaderFactory;
    private final DocumentTypeManager docTypeManager;

    public StreamReaderV3(FeedReaderFactory feedReaderFactory, DocumentTypeManager docTypeManager) {
        this.feedReaderFactory = feedReaderFactory;
        this.docTypeManager = docTypeManager;
    }

    public FeedOperation getNextOperation(InputStream requestInputStream, FeederSettings settings) throws Exception {
        FeedOperation op = null;
        int length = this.readByteLength(requestInputStream);
        try (ByteLimitedInputStream limitedInputStream = new ByteLimitedInputStream(requestInputStream, length);){
            FeedReader reader = this.feedReaderFactory.createReader(limitedInputStream, this.docTypeManager, settings.dataFormat);
            op = reader.read();
        }
        return op;
    }

    public Optional<String> getNextOperationId(InputStream requestInputStream) throws IOException {
        int c;
        StringBuilder idBuf = new StringBuilder(100);
        while ((c = requestInputStream.read()) != -1 && c != 32) {
            idBuf.append((char)c);
        }
        if (idBuf.length() == 0) {
            return Optional.empty();
        }
        return Optional.of(Encoder.decode((String)idBuf.toString(), (StringBuilder)new StringBuilder(idBuf.length())).toString());
    }

    private int readByteLength(InputStream requestInputStream) throws IOException {
        int c;
        StringBuilder lenBuf = new StringBuilder(8);
        while ((c = requestInputStream.read()) != -1 && c != 10) {
            lenBuf.append((char)c);
        }
        if (lenBuf.length() == 0) {
            throw new IllegalStateException("Operation length missing.");
        }
        return Integer.valueOf(lenBuf.toString(), 16);
    }

    public static InputStream unzipStreamIfNeeded(HttpRequest httpRequest) throws IOException {
        String contentEncodingHeader = httpRequest.getHeader("content-encoding");
        if ("gzip".equals(contentEncodingHeader)) {
            return new GZIPInputStream(httpRequest.getData());
        }
        return httpRequest.getData();
    }
}

