/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.vespa.http.client.config.FeedParams;

public class FeederSettings {
    private static final Route DEFAULT_ROUTE = Route.parse((String)"default");
    public final boolean drain;
    public final Route route;
    public final boolean denyIfBusy;
    public final FeedParams.DataFormat dataFormat;
    public final String priority;
    public final Integer traceLevel;

    public FeederSettings(HttpRequest request) {
        String tmpDrain = request.getHeader("X-Yahoo-Feed-Drain");
        this.drain = tmpDrain != null ? Boolean.parseBoolean(tmpDrain) : false;
        String tmpRoute = request.getHeader("X-Yahoo-Feed-Route");
        this.route = tmpRoute != null ? Route.parse((String)tmpRoute) : DEFAULT_ROUTE;
        String tmpDenyIfBusy = request.getHeader("X-Yahoo-Feed-Deny-If-Busy");
        this.denyIfBusy = tmpDenyIfBusy != null ? Boolean.parseBoolean(tmpDenyIfBusy) : false;
        String tmpDataFormat = request.getHeader("X-Yahoo-Feed-Data-Format");
        this.dataFormat = tmpDataFormat != null ? FeedParams.DataFormat.valueOf((String)tmpDataFormat) : FeedParams.DataFormat.XML_UTF8;
        tmpDataFormat = request.getHeader("X-Yahoo-Feed-Priority");
        this.priority = tmpDataFormat != null ? tmpDataFormat : null;
        tmpDataFormat = request.getHeader("X-Yahoo-Feed-Trace-Level");
        this.traceLevel = tmpDataFormat != null ? Integer.valueOf(tmpDataFormat) : null;
    }
}

