/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.storage.searcher;

import com.yahoo.log.LogLevel;
import com.yahoo.prelude.templates.Context;
import com.yahoo.prelude.templates.UserTemplate;
import com.yahoo.search.Result;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.storage.searcher.DocumentHit;
import com.yahoo.storage.searcher.DocumentRemoveHit;
import com.yahoo.storage.searcher.MessageBusErrorMessage;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;

@Deprecated
public class DocumentXMLTemplate
extends UserTemplate<Writer> {
    private static final Logger log = Logger.getLogger(DocumentXMLTemplate.class.getName());

    public DocumentXMLTemplate() {
        super("vespa_xml");
    }

    public DocumentXMLTemplate(String mimeType, String encoding) {
        super("vespa_xml", mimeType, encoding);
    }

    private void writeErrorMessage(Writer writer, String type, int code, String message, String detailedMessage) throws IOException {
        writer.write("<error type=\"" + type + "\" code=\"" + code + "\" message=\"");
        writer.write(XML.xmlEscape((String)message, (boolean)true));
        if (detailedMessage != null) {
            writer.write(": ");
            writer.write(XML.xmlEscape((String)detailedMessage, (boolean)true));
        }
        writer.write("\"/>\n");
    }

    private void writeGenericErrorMessage(Writer writer, ErrorMessage message) throws IOException {
        if (message instanceof MessageBusErrorMessage) {
            this.writeErrorMessage(writer, "messagebus", ((MessageBusErrorMessage)message).getMessageBusCode(), message.getMessage(), message.getDetailedMessage());
        } else {
            this.writeErrorMessage(writer, "searcher", message.getCode(), message.getMessage(), message.getDetailedMessage());
        }
    }

    public void error(Context context, Writer writer) throws IOException {
        writer.write("<errors>\n");
        ErrorHit errorHit = ((Result)context.get("result")).hits().getErrorHit();
        if (errorHit == null || errorHit.errors().isEmpty()) {
            ErrorMessage message = ((Result)context.get("result")).hits().getError();
            this.writeGenericErrorMessage(writer, message);
        } else {
            for (ErrorMessage message : errorHit.errors()) {
                this.writeGenericErrorMessage(writer, message);
            }
        }
        writer.write("</errors>\n");
    }

    public void header(Context context, Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<result>\n");
        HitGroup rootGroup = ((Result)context.get("result")).hits();
        if (rootGroup.getField("visitorContinuationToken") != null) {
            writer.write("<continuation>" + rootGroup.getField("visitorContinuationToken") + "</continuation>");
        }
    }

    public void footer(Context context, Writer writer) throws IOException {
        writer.write("</result>\n");
    }

    public void hit(Context context, Writer writer) throws IOException {
        Hit hit = (Hit)context.get("hit");
        if (hit instanceof DocumentHit) {
            DocumentHit docHit = (DocumentHit)hit;
            if (docHit.getDocument() != null) {
                writer.write(docHit.getDocument().toXML("  "));
            }
        } else if (hit instanceof DocumentRemoveHit) {
            this.writeDocumentRemoveHit(writer, (DocumentRemoveHit)hit);
        } else {
            log.log(LogLevel.WARNING, "Cannot render document XML; expected hit of type com.yahoo.storage.searcher.Document[Remove]Hit, got " + hit.getClass().getName() + ". Is there another backend searcher present?");
        }
    }

    private void writeDocumentRemoveHit(Writer writer, DocumentRemoveHit remove) throws IOException {
        writer.write("<remove documentid=\"");
        writer.write(XML.xmlEscape((String)remove.getIdOfRemovedDoc().toString()));
        writer.write("\"/>\n");
    }

    public void hitFooter(Context context, Writer writer) throws IOException {
    }

    public void noHits(Context context, Writer writer) throws IOException {
    }
}

