/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.collections.Tuple2;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.net.HostName;
import com.yahoo.vespa.http.client.core.OperationStatus;
import com.yahoo.vespa.http.server.ClientState;
import com.yahoo.vespa.http.server.ErrorHttpResponse;
import com.yahoo.vespa.http.server.FeedHandlerV3;
import com.yahoo.vespa.http.server.FeedReaderFactory;
import com.yahoo.vespa.http.server.FeedReplyReader;
import com.yahoo.vespa.http.server.FeedResponse;
import com.yahoo.vespa.http.server.Feeder;
import com.yahoo.vespa.http.server.FeederSettings;
import com.yahoo.vespa.http.server.UnknownClientException;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;

public class FeedHandler
extends LoggingRequestHandler {
    private final ExecutorService workers = Executors.newCachedThreadPool(ThreadFactoryFactory.getThreadFactory((String)"feedhandler"));
    private final DocumentTypeManager docTypeManager;
    private final Map<String, ClientState> clients;
    private final ScheduledThreadPoolExecutor cron;
    private final SessionCache sessionCache;
    protected final ReplyHandler feedReplyHandler;
    private final AtomicLong sessionId;
    private final Metric metric;
    private static final List<Integer> serverSupportedVersions = Collections.unmodifiableList(Arrays.asList(2));
    private final String localHostname;
    private final FeedHandlerV3 feedHandlerV3;

    @Inject
    public FeedHandler(LoggingRequestHandler.Context parentCtx, DocumentmanagerConfig documentManagerConfig, SessionCache sessionCache, ThreadpoolConfig threadpoolConfig, MetricReceiver metricReceiver) throws Exception {
        super(parentCtx);
        DocumentApiMetrics metricsHelper = new DocumentApiMetrics(metricReceiver, "vespa.http.server");
        this.feedHandlerV3 = new FeedHandlerV3(parentCtx, documentManagerConfig, sessionCache, threadpoolConfig, metricsHelper);
        this.docTypeManager = this.createDocumentManager(documentManagerConfig);
        this.clients = new HashMap<String, ClientState>();
        this.sessionCache = sessionCache;
        this.sessionId = new AtomicLong(new Random(System.currentTimeMillis()).nextLong());
        this.feedReplyHandler = new FeedReplyReader(parentCtx.getMetric(), metricsHelper);
        this.cron = new ScheduledThreadPoolExecutor(1, ThreadFactoryFactory.getThreadFactory((String)"feedhandler.cron"));
        this.cron.scheduleWithFixedDelay(new CleanClients(), 16L, 11L, TimeUnit.MINUTES);
        this.metric = parentCtx.getMetric();
        this.localHostname = FeedHandler.resolveLocalHostname();
    }

    protected DocumentTypeManager createDocumentManager(DocumentmanagerConfig documentManagerConfig) {
        return new DocumentTypeManager(documentManagerConfig);
    }

    private Tuple2<HttpResponse, Integer> checkProtocolVersion(com.yahoo.container.jdisc.HttpRequest request) {
        return FeedHandler.doCheckProtocolVersion(request.getJDiscRequest().headers().get((Object)"X-Yahoo-Feed-Protocol-Version"));
    }

    static Tuple2<HttpResponse, Integer> doCheckProtocolVersion(List<String> clientSupportedVersions) {
        int version;
        List<String> washedClientVersions = FeedHandler.splitVersions(clientSupportedVersions);
        if (washedClientVersions == null || washedClientVersions.isEmpty()) {
            return new Tuple2((Object)new ErrorHttpResponse(406, "Request did not contain X-Yahoo-Feed-Protocol-Versionheader. Server supports protocol versions " + serverSupportedVersions), (Object)-1);
        }
        if (washedClientVersions.contains("3")) {
            version = 3;
        } else if (washedClientVersions.contains("2")) {
            version = 2;
        } else {
            return new Tuple2((Object)new ErrorHttpResponse(406, "Could not parse X-Yahoo-Feed-Protocol-Versionheader of request (values: " + washedClientVersions + "). Server supports protocol versions " + serverSupportedVersions), (Object)-1);
        }
        return new Tuple2(null, (Object)version);
    }

    private static List<String> splitVersions(List<String> clientSupportedVersions) {
        ArrayList<String> splittedVersions = new ArrayList<String>();
        for (String v : clientSupportedVersions) {
            if (v == null || v.trim().isEmpty()) continue;
            if (!v.contains(",")) {
                splittedVersions.add(v.trim());
                continue;
            }
            for (String part : v.split(",")) {
                if ((part = part.trim()).isEmpty()) continue;
                splittedVersions.add(part);
            }
        }
        return splittedVersions;
    }

    public HttpResponse handle(com.yahoo.container.jdisc.HttpRequest request) {
        Feeder feeder;
        Tuple2<HttpResponse, Integer> protocolVersion = this.checkProtocolVersion(request);
        if (protocolVersion.first != null) {
            return (HttpResponse)protocolVersion.first;
        }
        if (3 == (Integer)protocolVersion.second) {
            return this.feedHandlerV3.handle(request);
        }
        LinkedBlockingQueue<OperationStatus> operations = new LinkedBlockingQueue<OperationStatus>();
        Tuple2<String, Boolean> clientId = this.sessionId(request);
        if (clientId.second != null && ((Boolean)clientId.second).booleanValue() && this.log.isLoggable((Level)LogLevel.DEBUG)) {
            this.log.log((Level)LogLevel.DEBUG, "Received initial request from client with session ID " + (String)clientId.first + ", protocol version " + protocolVersion.second);
        }
        try {
            feeder = this.createFeeder(request, request.getData(), operations, (String)clientId.first, (Boolean)clientId.second, (Integer)protocolVersion.second);
            this.workers.submit(feeder);
        }
        catch (UnknownClientException uce) {
            String msg = Exceptions.toMessageString((Throwable)uce);
            this.log.log(LogLevel.WARNING, msg);
            return new ErrorHttpResponse(400, msg);
        }
        catch (Exception e) {
            String msg = "Could not initialize document parsing";
            this.log.log(LogLevel.WARNING, "Could not initialize document parsing", e);
            return new ErrorHttpResponse(500, msg + ": " + Exceptions.toMessageString((Throwable)e));
        }
        try {
            feeder.waitForRequestReceived();
        }
        catch (InterruptedException e) {
            return new ErrorHttpResponse(500, e.getMessage());
        }
        return new FeedResponse(200, operations, (Integer)protocolVersion.second, (String)clientId.first);
    }

    protected static InputStream unzipStreamIfNeeded(InputStream inputStream, com.yahoo.container.jdisc.HttpRequest httpRequest) throws IOException {
        String contentEncodingHeader = httpRequest.getHeader("content-encoding");
        if ("gzip".equals(contentEncodingHeader)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    protected Feeder createFeeder(com.yahoo.container.jdisc.HttpRequest request, InputStream requestInputStream, BlockingQueue<OperationStatus> operations, String clientId, boolean sessionIdWasGeneratedJustNow, int protocolVersion) throws Exception {
        if (protocolVersion != 2) {
            throw new IllegalStateException("Protocol version " + protocolVersion + " not supported.");
        }
        return new Feeder(FeedHandler.unzipStreamIfNeeded(requestInputStream, request), new FeedReaderFactory(), this.docTypeManager, operations, this.popClient(clientId), new FeederSettings(request), clientId, sessionIdWasGeneratedJustNow, this.sourceSessionParams(request), this.sessionCache, this, this.metric, this.feedReplyHandler, this.localHostname);
    }

    private Tuple2<String, Boolean> sessionId(com.yahoo.container.jdisc.HttpRequest request) {
        boolean sessionIdWasGeneratedJustNow = false;
        String sessionId = request.getHeader("X-Yahoo-Feed-Session-Id");
        if (sessionId == null) {
            sessionId = Long.toString(this.sessionId.incrementAndGet()) + "-" + FeedHandler.remoteHostAddressAndPort(request.getJDiscRequest()) + "#" + this.localHostname;
            sessionIdWasGeneratedJustNow = true;
        }
        return new Tuple2((Object)sessionId, (Object)sessionIdWasGeneratedJustNow);
    }

    private static String remoteHostAddressAndPort(HttpRequest httpRequest) {
        SocketAddress remoteAddress = httpRequest.getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)remoteAddress;
            return isa.getAddress().getHostAddress() + "-" + isa.getPort();
        }
        return "";
    }

    private static String resolveLocalHostname() {
        String hostname = HostName.getLocalhost();
        if (hostname.equals("localhost")) {
            return "";
        }
        return hostname;
    }

    protected SourceSessionParams sourceSessionParams(com.yahoo.container.jdisc.HttpRequest request) {
        SourceSessionParams params = new SourceSessionParams();
        String timeout = request.getHeader("X-Yahoo-Feed-Timeout");
        if (timeout != null) {
            try {
                params.setTimeout(Double.parseDouble(timeout));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return params;
    }

    protected void destroy() {
        this.feedHandlerV3.destroy();
        Thread destroyer = new Thread(() -> this.internalDestroy());
        destroyer.setDaemon(true);
        destroyer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDestroy() {
        super.destroy();
        this.workers.shutdown();
        this.cron.shutdown();
        Map<String, ClientState> map = this.clients;
        synchronized (map) {
            for (ClientState client : this.clients.values()) {
                client.sourceSession.getReference().close();
            }
            this.clients.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putClient(String sessionId, ClientState value) {
        Map<String, ClientState> map = this.clients;
        synchronized (map) {
            this.clients.put(sessionId, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientState popClient(String sessionId) {
        Map<String, ClientState> map = this.clients;
        synchronized (map) {
            return this.clients.remove(sessionId);
        }
    }

    void forceRunCleanClients() {
        new CleanClients().run();
    }

    private class CleanClients
    implements Runnable {
        private CleanClients() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<ClientState> clientsToShutdown = new ArrayList<ClientState>();
            long now = System.currentTimeMillis();
            Map map = FeedHandler.this.clients;
            synchronized (map) {
                Iterator i = FeedHandler.this.clients.entrySet().iterator();
                while (i.hasNext()) {
                    ClientState client = (ClientState)i.next().getValue();
                    if (now - client.creationTime <= 600000L) continue;
                    clientsToShutdown.add(client);
                    i.remove();
                }
            }
            for (ClientState client : clientsToShutdown) {
                client.sourceSession.getReference().close();
            }
        }
    }
}

