/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.yahoo.document.restapi.Response;
import com.yahoo.document.restapi.RestApiException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;

public class RestUri {
    public static final char NUMBER_STREAMING = 'n';
    public static final char GROUP_STREAMING = 'g';
    public static final String DOCUMENT = "document";
    public static final String V_1 = "v1";
    public static final String ID = "id:";
    private final String namespace;
    private final String documentType;
    private final String docId;
    private Optional<Group> group = Optional.empty();
    private final String rawPath;

    public String getRawPath() {
        return this.rawPath;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getDocId() {
        return this.docId;
    }

    public Optional<Group> getGroup() {
        return this.group;
    }

    public String generateFullId() {
        return ID + this.namespace + ":" + this.documentType + ":" + (this.getGroup().isPresent() ? this.group.get().name + "=" + this.group.get().value : "") + ":" + this.docId;
    }

    public RestUri(URI uri) throws RestApiException {
        this.rawPath = uri.getRawPath();
        PathParser pathParser = new PathParser(this.rawPath);
        if (!(pathParser.nextTokenOrException().equals("") && pathParser.nextTokenOrException().equals(DOCUMENT) && pathParser.nextTokenOrException().equals(V_1))) {
            RestUri.throwUsage(uri.getRawPath());
        }
        this.namespace = pathParser.nextTokenOrException();
        this.documentType = pathParser.nextTokenOrException();
        switch (pathParser.nextTokenOrException()) {
            case "number": {
                this.group = Optional.of(new Group('n', pathParser.nextTokenOrException()));
                break;
            }
            case "docid": {
                this.group = Optional.empty();
                break;
            }
            case "group": {
                this.group = Optional.of(new Group('g', pathParser.nextTokenOrException()));
                break;
            }
            default: {
                RestUri.throwUsage(uri.getRawPath());
            }
        }
        this.docId = pathParser.restOfPath();
    }

    private static void throwUsage(String inputPath) throws RestApiException {
        throw new RestApiException(Response.createErrorResponse(400, "Expected: .../{namespace}/{document-type}/group/{name}/[{user-specified}]   .../{namespace}/{document-type}/docid/[{user-specified}]  : but got " + inputPath, apiErrorCodes.ERROR_ID_BASIC_USAGE));
    }

    static class PathParser {
        public static final long ERROR_ID_DECODING_PATH = -10L;
        final List<String> rawParts;
        final String originalPath;
        int readPos = 0;

        public PathParser(String path) {
            this.originalPath = path;
            this.rawParts = Splitter.on((char)'/').splitToList((CharSequence)path);
        }

        String nextTokenOrException() throws RestApiException {
            if (this.readPos >= this.rawParts.size()) {
                RestUri.throwUsage(this.originalPath);
            }
            String nextToken = this.rawParts.get(this.readPos++);
            return this.urlDecodeOrException(nextToken);
        }

        String restOfPath() throws RestApiException {
            String rawId = Joiner.on((String)"/").join(this.rawParts.listIterator(this.readPos));
            return this.urlDecodeOrException(rawId);
        }

        String urlDecodeOrException(String url) throws RestApiException {
            try {
                return URLDecoder.decode(url, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RestApiException(Response.createErrorResponse(400, "Problems decoding the URI: " + e.getMessage(), apiErrorCodes.ERROR_ID_DECODING_PATH));
            }
        }
    }

    public static class Group {
        public final char name;
        public final String value;

        Group(char name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static enum apiErrorCodes {
        ERROR_ID_BASIC_USAGE(-1L),
        ERROR_ID_DECODING_PATH(-2L),
        VISITOR_ERROR(-3L),
        NO_ROUTE_WHEN_NOT_PART_OF_MESSAGEBUS(-4L),
        SEVERAL_CLUSTERS(-5L),
        URL_PARSING(-6L),
        INVALID_CREATE_VALUE(-7L),
        TOO_MANY_PARALLEL_REQUESTS(-8L),
        MISSING_CLUSTER(-9L),
        INTERNAL_EXCEPTION(-9L),
        DOCUMENT_CONDITION_NOT_MET(-10L),
        DOCUMENT_EXCPETION(-11L),
        PARSER_ERROR(-11L),
        GROUP_AND_EXPRESSION_ERROR(-12L),
        TIME_OUT(-13L),
        INTERRUPTED(-14L),
        UNSPECIFIED(-15L);

        public final long value;

        private apiErrorCodes(long value) {
            this.value = value;
        }
    }
}

