/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.google.inject.Inject;
import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentapi.messagebus.protocol.RemoveLocationMessage;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedapi.MessageProcessor;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.feedapi.SingleSender;
import com.yahoo.feedhandler.FeedResponse;
import com.yahoo.feedhandler.VespaFeedHandlerBase;
import com.yahoo.jdisc.Metric;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaclient.ClusterDef;
import com.yahoo.vespaclient.config.FeederConfig;
import java.util.concurrent.Executor;

public class VespaFeedHandlerRemoveLocation
extends VespaFeedHandlerBase {
    @Inject
    public VespaFeedHandlerRemoveLocation(FeederConfig feederConfig, LoadTypeConfig loadTypeConfig, DocumentmanagerConfig documentmanagerConfig, SlobroksConfig slobroksConfig, ClusterListConfig clusterListConfig, Executor executor, Metric metric) throws Exception {
        super(feederConfig, loadTypeConfig, documentmanagerConfig, slobroksConfig, clusterListConfig, executor, metric);
    }

    VespaFeedHandlerRemoveLocation(FeedContext context, Executor executor) throws Exception {
        super(context, executor);
    }

    public HttpResponse handle(HttpRequest request) {
        MessagePropertyProcessor.PropertySetter properties = this.getPropertyProcessor().buildPropertySetter(request);
        if (request.getProperty("route") == null) {
            if (this.context.getClusterList().getStorageClusters().size() == 0) {
                return new FeedResponse(null).addError("No storage clusters configured and no alternate route specified.");
            }
            if (this.context.getClusterList().getStorageClusters().size() > 1) {
                return new FeedResponse(null).addError("More than one storage cluster configured and no route specified.");
            }
            properties.setRoute(Route.parse((String)((ClusterDef)this.context.getClusterList().getStorageClusters().get(0)).getName()));
        }
        FeedResponse response = new FeedResponse(new RouteMetricSet(properties.getRoute().toString(), null));
        SingleSender sender = new SingleSender((SharedSender.ResultCallback)response, this.getSharedSender(properties.getRoute().toString()));
        sender.addMessageProcessor((MessageProcessor)properties);
        String user = request.getProperty("user");
        String group = request.getProperty("group");
        String selection = request.getProperty("selection");
        boolean oneFound = user != null ^ group != null ^ selection != null;
        if (!oneFound) {
            response.addError("Exactly one of \"user\", \"group\" or \"selection\" must be specified for removelocation");
            return response;
        }
        if (user != null) {
            selection = "id.user=" + user;
        }
        if (group != null) {
            selection = "id.group=\"" + group + "\"";
        }
        sender.send((Message)new RemoveLocationMessage(selection));
        sender.done();
        long millis = this.getTimeoutMillis(request);
        boolean completed = sender.waitForPending(millis);
        if (!completed) {
            response.addError("Timed out after " + millis + " ms waiting for responses");
        }
        return response;
    }
}

